<?php
// Source code example for Web Database Applications with PHP and MySQL, 2nd Edition
// Author: Hugh E. Williams and David Lane, 2001-3
// 
// Unless otherwise stated, the source code distributed with this book can be
// redistributed in source or binary form so long as an acknowledgment appears
// in derived source files.
// The citation should list that the code comes from Hugh E. Williams and David 
// Lane, "Web Database Application with PHP and MySQL" published by O'Reilly & 
// Associates.
//
// This code is under copyright and cannot be included in any other book,
// publication, or educational product without permission from O'Reilly &
// Associates. No warranty is attached; we cannot take responsibility for errors 
// or fitness for use.

// Skrypt zarzdzajcy procesem logowania.
// Powinien by wywoywany gdy uytkownik nie jest zalogowany.
// Jeeli jest zalogowany, przekierowuje na stron wywoujc.
// Jeeli uytkownik nie jest zalogowany, pokazuje formularz logowania.

require_once "DB.php";
require_once "../includes/winestore.inc";
require_once "../includes/authenticate.inc";
require_once "../includes/validate.inc";

set_error_handler("customHandler");

function checkLogin($loginUsername, $loginPassword, $connection)
{

  if (authenticateUser($loginUsername, $loginPassword, $connection))
  {
     registerLogin($loginUsername);

     // Kasuje zmienn formVars wic w przyszoci formularz bdzie pusty.
     unset($_SESSION["loginFormVars"]);
     unset($_SESSION["loginErrors"]);

     header("Location: " . S_MAIN);
     exit;
  }
  else
  {
     // Rejestrowanie komunikatu bdu.
     $_SESSION["message"] = "Nieprawidowa nazwa uytkownika lub haso. Logowanie nieudane.";

     header("Location: " . S_LOGIN);
     exit;
  }        
}

// ------

session_start();

$connection = DB::connect($dsn, true);

if (DB::isError($connection))
  trigger_error($connection->getMessage(), E_USER_ERROR); 

// Sprawdzenie, czy uytkownik jest zalogowany.
if (isset($_SESSION["loginUsername"]))
{
     $_SESSION["message"] = "Jeste ju zalogowany!";
     header("Location: " . S_HOME);
     exit;
}

// Rejestruje i kasuje tablic bdw - na wszelki wypadek!
if (isset($_SESSION["loginErrors"]))
   unset($_SESSION["loginErrors"]);
$_SESSION["loginErrors"] = array();

// Przygotowuje tablic formVars na zmienne POST.
$_SESSION["loginFormVars"] = array();

foreach($_POST as $varname => $value)
   $_SESSION["loginFormVars"]["{$varname}"] = 
   pearclean($_POST, $varname, 50, $connection);

// Kontrola poprawnoci hasa -- czy zostao podane i ma dugo pomidzy 
// 6 a 8 znakw?
if (checkMandatory("loginPassword", "password", 
              "loginErrors", "loginFormVars"))
  checkMinAndMaxLength("loginPassword", 6, 8, "password", 
                  "loginErrors", "loginFormVars");

// Kontrola poprawnoci adresu email -- czy zosta podany i jest prawidowy?
if (checkMandatory("loginUsername", "email/username", 
              "loginErrors", "loginFormVars"))
  emailCheck("loginUsername", "email/username", 
             "loginErrors", "loginFormVars");

// Sprawdzenie, czy jest to poprawny uytkownik, jeeli tak, zalogowanie go.
checkLogin($_SESSION["loginFormVars"]["loginUsername"], 
           $_SESSION["loginFormVars"]["loginPassword"], 
           $connection);
?>
