<?php
// Source code example for Web Database Applications with PHP and MySQL, 2nd Edition
// Author: Hugh E. Williams and David Lane, 2001-3
// 
// Unless otherwise stated, the source code distributed with this book can be
// redistributed in source or binary form so long as an acknowledgment appears
// in derived source files.
// The citation should list that the code comes from Hugh E. Williams and David 
// Lane, "Web Database Application with PHP and MySQL" published by O'Reilly & 
// Associates.
//
// This code is under copyright and cannot be included in any other book,
// publication, or educational product without permission from O'Reilly &
// Associates. No warranty is attached; we cannot take responsibility for errors 
// or fitness for use.

// Dodanie nowego uytkownika do tablicy users.
function newUser($loginUsername, $loginPassword, $cust_id, $connection)
{
   // Tworzenie zaszyfrowanego hasa.
   $stored_password = md5(trim($loginPassword));

   // Wstawienie nowego uytkownika do tabeli users.
   $query = "INSERT INTO users SET 
             cust_id = {$cust_id},
             password = '{$stored_password}',
             user_name = '{$loginUsername}'";

   $result = $connection->query($query);

   if (DB::isError($result))
      trigger_error($result->getMessage(), E_USER_ERROR); 
}

// Sprawdzenie, czy uytkownik ma konto ktremu odpowiada nazwa uzytkownika i haso.
function authenticateUser($loginUsername, $loginPassword, $connection)
{
   // Utworzenie zakodowanego hasa .
   $password_digest = md5(trim($loginPassword));

   // Utworzenie zapytania SQL wyszukujacego uytkownika.
   $query = "SELECT password FROM users
             WHERE user_name = '$loginUsername'
             AND password = '$password_digest'";

   $result = $connection->query($query);

   if (DB::isError($result))
      trigger_error($result->getMessage(), E_USER_ERROR);

   // Dokadnie jeden wiersz? - znaleziony uytkownik.
   if ($result->numRows() != 1)
      return false;
   else
      return true;
}

// Rejestracja zalogowanego uytkownika.
function registerLogin($loginUsername)
{
   // Rejestracja loginUsername w celu pokazania, e uytkownik jest zalogowany
   $_SESSION["loginUsername"] = $loginUsername;

   // Rejestracja adresu IP dla uruchomionej sesji
   $_SESSION["loginIP"] = $_SERVER["REMOTE_ADDR"];
}

// Logout (wyrejestrowanie)
function unregisterLogin()
{
   // Sprawdzenie, czy uytkownik nie jest zalogowany.
   if (isset($_SESSION["loginUsername"]))
      unset($_SESSION["loginUsername"]);

   if (isset($_SESSION["loginIP"]))
      unset($_SESSION["loginIP"]);
}

// Podczenie sesji i sprawdzanie, czy uytkowik jest autoryzowany
// i asres IP klienta zgadza si z adresem zarejestrowanym w sesji.
function sessionAuthenticate($destinationScript)
{
  // Sprawdzenie, czy uytkownik nie jest zalogowany.
  if (!isset($_SESSION["loginUsername"]))
  {
    // danie nie naley do sesji.
    $_SESSION["message"] = "Nie jeste autoryzowany {$_SERVER["REQUEST_URI"]}";

    unregisterLogin();
    header("Location: {$destinationScript}");
    exit;
  }

  // Sprawdzenie, czy danie jest z innego adresu IP ni poprzednio
  if (isset($_SESSION["loginIP"]) &&
     ($_SESSION["loginIP"] != $_SERVER["REMOTE_ADDR"]))
  {
    // danie nie pochodzi z komputera
    // z ktrego otwarto sesj
    // JEST TO BY MOE PRBA PRZEJCIA SESJI

    $_SESSION["message"] = "Nie jeste autoryzowany do dostpu 
                            {$_SERVER["REQUEST_URI"]} z tego adresu
                            {$_SERVER["REMOTE_ADDR"]}";

    unregisterLogin();
    header("Location: {$destinationScript}");
    exit;
  }
}

?>
