<?php
// Source code example for Web Database Applications with PHP and MySQL, 2nd Edition
// Author: Hugh E. Williams, 2001-3
// 
// Unless otherwise stated, the source code distributed with this book can be
// redistributed in source or binary form so long as an acknowledgment appears
// in derived source files.
// The citation should list that the code comes from Hugh E. Williams and David 
// Lane, "Web Database Application with PHP and MySQL" published by O'Reilly & 
// Associates.
//
// This code is under copyright and cannot be included in any other book,
// publication, or educational product without permission from O'Reilly &
// Associates. No warranty is attached; we cannot take responsibility for errors 
// or fitness for use.

// Skrypt finalizuje zamwienie.
// Oczekuje, e w koszyku znajduj si towary,
// a uytkownik jest zalogowany.

require_once "DB.php";
require_once "../includes/winestore.inc";
require_once "../includes/authenticate.inc";

set_error_handler("customHandler");

session_start();

// Podczenie do autoryzowanej sesji.
sessionAuthenticate(S_SHOWCART);

// Sprawdzenie, czy koszyk nie jest pusty.
if (!isset($_SESSION["order_no"]))
{
   $_SESSION["message"] = "Koszyk jest pusty!";

   header("Location: " . S_SHOWCART);
   exit;
}   

$connection = DB::connect($dsn, true);
if (DB::isError($connection))
   trigger_error($connection->getMessage(), E_USER_ERROR); 

// Aby zrealizowa zamwienie, trzeba zablokowa kilka tabel.
$query = "LOCK TABLES inventory WRITE, 
                      orders WRITE, 
                      items WRITE, 
                      users READ, 
                      customer READ";

$result = $connection->query($query);
if (DB::isError($result))
   trigger_error($result->getMessage(), E_USER_ERROR); 

// Przetwarzanie kolejnych pozycji w koszyku w celu sprawdzenia, 
// czy w magazynie znajduje si odpowiednia ilo towaru.

$query = "SELECT * FROM items 
          WHERE cust_id = -1 
          AND order_id = {$_SESSION["order_no"]}";

// Inicjalizacja pustego komunikatu bdu.
$_SESSION["message"] = "";

$result = $connection->query($query);
if (DB::isError($result))
   trigger_error($result->getMessage(), E_USER_ERROR); 

// Pobranie nastpnego wina z koszyka.
for ($winesInCart = 0; 
     $winesInCart < $result->numRows(); 
     $winesInCart++)
{
   $cartRow[$winesInCart] = $result->fetchRow(DB_FETCHMODE_ASSOC);  

   // Czy w magazynie jest wystarczajca ilo wina?
   $query = "SELECT COUNT(on_hand), SUM(on_hand)
             FROM inventory 
             WHERE wine_id = {$cartRow[$winesInCart]["wine_id"]}";

   $stockResult = $connection->query($query);
   if (DB::isError($stockResult))
      trigger_error($stockResult->getMessage(), E_USER_ERROR); 
                                    
   $on_hand = $stockResult->fetchRow(DB_FETCHMODE_ASSOC);

   if ($on_hand["COUNT(on_hand)"] == 0)
      $available = 0;
   else
      $available = $on_hand["SUM(on_hand)"];
                   
   // Czy w koszyku znajduje si wicej wina, ni jest dostpne do sprzedania?
   if ($cartRow[$winesInCart]["qty"] > $available)
   {

      if ($available == 0)
         $_SESSION["message"] = "Przepraszamy! Wasnie zostao sprzedane cae wino " . 
                   showWine($cartRow[$winesInCart]["wine_id"], NULL) .
                   "\n<br>";
      else 
         $_SESSION["message"] .= "Przepraszamy! Zostao tylko {$on_hand["SUM(on_hand)"]}  
                     butelek wina " . 
                     showWine($cartRow[$winesInCart]["wine_id"], NULL) .
                     "\n<br>";

      // Zmiana ilocni zamwionej przez klienta na ilo znajdujc si w magazynie.
      $query = "UPDATE items
                SET qty = {$available}
                WHERE cust_id = -1
                AND order_id = {$_SESSION["order_no"]}
                AND item_id = {$cartRow[$winesInCart]["item_id"]}";

      $result = $connection->query($query);
      if (DB::isError($result))
         trigger_error($result->getMessage(), E_USER_ERROR); 
   }                                                           
} // for $winesInCart < $result->numRows()

// Sprawdzilimy, czy w magazynie dostpna jest odpowiednia ilo wina.
// Jeeli tak,  moemy kontynuowa przetwarzanie zamwienia. Jeeli nie,
// wywietlamy zmienion zawarto koszyka, aby uytkownik zdecydowa
// czy realizowa to zamwienie.

if (empty($_SESSION["message"]))
{
   // Wszystko w  porzdku - idziemy dalej!

   // Na pocztek szukamy identyfikatora uytkownika i nastepnej wartoci
   // order_id dla tego klienta.
   $cust_id = getCust_id($_SESSION["loginUsername"], $connection);

   $query = "SELECT max(order_id) 
             FROM orders 
             WHERE cust_id = {$cust_id}";
   $result = $connection->query($query);
   if (DB::isError($result))
      trigger_error($result->getMessage(), E_USER_ERROR); 

   $row = $result->fetchRow(DB_FETCHMODE_ASSOC);

   $newOrder_no = $row["max(order_id)"] + 1;
   
   // Teraz zmieniamy wartoci cust_id oraz order_id w koszyku.
   $query = "UPDATE orders SET
             cust_id = {$cust_id},
             order_id = {$newOrder_no}
             WHERE order_id = {$_SESSION["order_no"]}
             AND cust_id = -1";

   $result = $connection->query($query);
   if (DB::isError($result))
      trigger_error($result->getMessage(), E_USER_ERROR); 

   $query = "UPDATE items SET
             cust_id = {$cust_id},
             order_id = {$newOrder_no}
             WHERE order_id = {$_SESSION["order_no"]}
             AND cust_id = -1";

   $result = $connection->query($query);
   if (DB::isError($result))
      trigger_error($result->getMessage(), E_USER_ERROR); 

   // Oprnienie koszyka.
   unset($_SESSION["order_no"]);

   // Teraz musimy zaktualizowa zawarto magazynu. 
   // Realizujemy to dla kolejnych wierszy koszyka.
   // Wiemy, e dla wszystkich wierszy mamy wystarczajc ilo
   // w magazynie, poniewa zostao to wczeniej sprawdzone.
   foreach($cartRow as $currentRow)
   {
      // Szukanie dostaw dla danego wina, zaczynajc od najstarszych.
      $query = "SELECT inventory_id, on_hand
                FROM inventory
                WHERE wine_id = {$currentRow["wine_id"]}
                ORDER BY date_added";

      $result = $connection->query($query);
      if (DB::isError($result))
         trigger_error($result->getMessage(), E_USER_ERROR); 

      // Jeeli nadal mamy jeszcze butelki do wysania...
      while($currentRow["qty"] > 0)
      {
         // Pobranie najstarszej dostawy.
         $row = $result->fetchRow(DB_FETCHMODE_ASSOC);

         // Czy znajduje si w niej wicej wina ni da tego uytkownik?
         if ($row["on_hand"] > $currentRow["qty"])
         {
            // Zmniejszanie stanu o liczb zamowion przez uytkownika.
            $query = "UPDATE inventory SET 
                      on_hand = on_hand - {$currentRow["qty"]}
                     WHERE wine_id = {$currentRow["wine_id"]}
                     AND inventory_id = {$row["inventory_id"]}";

            // Uytkownik ma ju cae zamwione wino.
            $currentRow["qty"] = 0;
         }
         else
         {
            // Usuwanie dostawy - reszt sprzedalimy temu uytkownikowi.
            $query = "DELETE FROM inventory 
                      WHERE wine_id = {$currentRow["wine_id"]}
                      AND inventory_id = {$row["inventory_id"]}";

            // Dostawa jest zmniejszana o liczbe zamwionych przez uytkownika
            // butelek, co najmniej o 1.
            $currentRow["qty"] -= $row["on_hand"];
         }   

         // Operacje UPDATE lub DELETE na dostawach
         $result = $connection->query($query);
         if (DB::isError($result))
            trigger_error($result->getMessage(), E_USER_ERROR); 
      }
   }
}
else
   $_SESSION["message"] .= 
     "\n<br>W koszyku zostay zmienione iloci zamwionych towarw\n.";

// Na koniec odblokowanie tabel.
$result = $connection->query("UNLOCK TABLES");
if (DB::isError($result))
   trigger_error($result->getMessage(), E_USER_ERROR); 

// Jeeli wszystko w porzdku, przekierowanie do strony wysyajcej e-mail 
// z potwierdzeniem, w przeciwnym przypadku powrt do strony koszyka i 
// wywietlenie komunikatu.
if (empty($_SESSION["message"]))
{
   header("Location: " . S_ORDER_4 . 
          "?cust_id={$cust_id}&order_id={$newOrder_no}");
   exit;
}
else
   header("Location: " . S_SHOWCART);
?>
