<?php
// Source code example for Web Database Applications with PHP and MySQL, 2nd Edition
// Author: Hugh E. Williams, 2001-3
// 
// Unless otherwise stated, the source code distributed with this book can be
// redistributed in source or binary form so long as an acknowledgment appears
// in derived source files.
// The citation should list that the code comes from Hugh E. Williams and David 
// Lane, "Web Database Application with PHP and MySQL" published by O'Reilly & 
// Associates.
//
// This code is under copyright and cannot be included in any other book,
// publication, or educational product without permission from O'Reilly &
// Associates. No warranty is attached; we cannot take responsibility for errors 
// or fitness for use.

// Oglne funkcje kontroli poprawnoci.

// Sprawdzenie, czy pole obowizkowe jest puste.
function checkMandatory($field, $errorString, $errors, $formVars)
{
   if (!isset($_SESSION["{$formVars}"]["{$field}"]) || 
       empty($_SESSION["{$formVars}"]["{$field}"])) 
   {
      $_SESSION["{$errors}"]["{$field}"] = 
         "Pole {$errorString} nie moe by puste.";
      return false;
   }
   return true;
}

// Sprawdzenie, czy pole ma dugo mniejsz od min lub wiksz od max.
function checkMinAndMaxLength($field, $minlength, $maxlength, 
                         $errorString, $errors, $formVars)
{
   if (isset($_SESSION["{$formVars}"]["{$field}"]) && 
      (strlen($_SESSION["{$formVars}"]["{$field}"]) < $minlength ||
       strlen($_SESSION["{$formVars}"]["{$field}"]) > $maxlength))
   {
      $_SESSION["{$errors}"]["{$field}"] = 
         "Warto pola {$errorString} musi by wiksza lub rwna " . 
         "{$minlength} oraz mniejsza lub rwna {$maxlength}. ";
      return false;
   }
   return true;
}

// Prosta kontrola poprawnoci kodu pocztowego -- lepsza jest przedstawiona w rozdziale 9!
function checkZipcode($field, $errorString, $errors, $formVars)
{
   if (isset($_SESSION["{$formVars}"]["{$field}"]) && 
       !ereg("^([0-9]{4,5})$", $_SESSION["{$formVars}"]["{$field}"]))
   {
      $_SESSION["{$errors}"]["{$field}"] = 
         "Kod pocztowy musi mie dugo 4 lub 5 znakw.";
      return false;
   }
   return true;
}

// Kontrola numeru telefonu
function checkPhone($field, $errorString, $errors, $formVars)
{
   $validPhoneExpr = "^([0-9]{2,3}[ ]?)?[0-9]{4}[ ]?[0-9]{4}$";

   if (isset($_SESSION["{$formVars}"]["{$field}"]) && 
       !ereg($validPhoneExpr, $_SESSION["{$formVars}"]["{$field}"]))
   {
      $_SESSION["{$errors}"]["{$field}"] = 
         "Warto pola {$field} musi mie dugo 8 znakw, " .
         "z opcjonalnym numerem kierunkowym o dugoci 2 lub 3 znakw.";
      return false;
   }
   return true;
}

// Sprawdzenie daty urodzenia, oraz tego, czy uzytkownik ma co najmniej 18 lat.
function checkDateAndAdult($field, $errorString, $errors, $formVars)
{
   if (!ereg("^([0-9]{2})/([0-9]{2})/([0-9]{4})$", 
             $_SESSION["{$formVars}"]["{$field}"], $parts))
   {
      $_SESSION["{$errors}"]["{$field}"] = 
         "Taba urodzenia nie jest zapisana w poprawnym " . 
         "formacie DD/MM/YYYY";
      return false;
   }

   if (!checkdate($parts[2],$parts[1],$parts[3]))
   {
      $_SESSION["{$errors}"]["{$field}"] = 
         "Data urodzenia nie jest prawidowa. Prosz " .
         "sprawdzi, czy miesic jest liczb pomidzy 1 a 12, " .
         "i dla podanego miesica istnieje dany dzie.";
      return false;
   }

   if (intval($parts[3]) < 1902 || 
       intval($parts[3]) > intval(date("Y")))
   {
      $_SESSION["{$errors}"]["{$field}"] = 
         "Musisz y, eby korzysta z tego serwisu.";
      return false;
   }
   
   $dob = mktime(0, 0, 0, $parts[2], $parts[1], $parts[3]);

   // Sprawdzenie, czy uytkownik ma co najmniej 18 lat.
   // W rozdziale 9 przedstawiona jest wersja dla Windows
   if ((float)$dob > (float)strtotime("-18years"))
   {
      $_SESSION["{$errors}"]["{$field}"] = 
         "Aby korzysta z tego serwisu musisz mie co najmniej 18 lat";
      return false;
   }
   return true;
}

// Sprawdzenie adresu e-mail
function emailCheck($field, $errorString, $errors, $formVars)
{
   // Sprawdzenie skadni.
   $validEmailExpr =  "^[0-9a-z~!#$%&_-]([.]?[0-9a-z~!#$%&_-])*" .
                      "@[0-9a-z~!#$%&_-]([.]?[0-9a-z~!#$%&_-])*$";

   if (!eregi($validEmailExpr, $_SESSION["{$formVars}"]["{$field}"]))
   {
      $_SESSION["{$errors}"]["{$field}"] =  
         "Adres e-mail musi by w formacje nazwa@domena.";
      return false;
   }

   // W rozdziale 7 znajduje si wersja dla Windows.
   if (function_exists("getmxrr") && 
       function_exists("gethostbyname"))
   {
     // Pobranie domeny z adresu e-mail
     $maildomain = 
        substr(strstr($_SESSION["{$formVars}"]["{$field}"], '@'), 1);

     if (!(getmxrr($maildomain, $temp) || 
           gethostbyname($maildomain) != $maildomain))
     {
       $_SESSION["{$errors}"]["{$field}"] = 
          "Domena nie istnieje.";
       return false;
     }
   }

   return true;
}

// Sprawdzenie numeru karty kredytowej za pomoc algorytmu Luhn-a.
function checkCard($field, $errors, $formVars)
{
  if (!ereg("^[0-9 ]*$", $_SESSION["{$formVars}"]["{$field}"]))
  {
    $_SESSION["{$errors}"]["{$field}"] = 
      "Numer karty kredytowej moe zawiera tylko cyfry i spacje.";
    return false;
  }

  // Usunicie spacji
  $_SESSION["{$formVars}"]["{$field}"] = ereg_replace('[ ]', '', $_SESSION["{$formVars}"]["{$field}"]);

  // Sprawdzenie pierwszych czterech cyfr
  $firstFour = intval(substr($_SESSION["{$formVars}"]["{$field}"], 0, 4));
  $type = "";
  $length = 0;

  if ($firstFour >= 8000 && $firstFour <= 8999)
  {
    // Wyprbuj: 8000 0000 0000 1001
    $type = "SurchargeCard";
    $length = 16;
  }

  if (empty($type))
  {
    $_SESSION["{$errors}"]["{$field}"] = 
      "Prosz sprawdzi dane swojej karty kredytowej.";
    return false;
  }

  if (strlen($_SESSION["{$formVars}"]["{$field}"]) != $length)
  {
    $_SESSION["{$errors}"]["{$field}"] = 
      "Numer karty kredytowej musi skada si z {$length} cyfr.";
    return false;
  }

  $check = 0;

 // Dodawanie co drugiej cyfry, zaczynajc od prawej strony.
  for($x=$length-1;$x>=0;$x-=2)
    $check += intval(substr($_SESSION["{$formVars}"]["{$field}"], $x, 1));

  // Dodawanie co drugiej podwojonej cyfry, zaczynajc od prawej strony -1.
  // Odjcie 9 jeeli podwojona warto jest wiksza ni 10
  for($x=$length-2;$x>=0;$x-=2)
  {
    $double = intval(substr($_SESSION["{$formVars}"]["{$field}"], $x, 1)) * 2;
    if ($double >= 10)
      $check += $double - 9;
    else
      $check += $double;
  }

  // Czy $check nie jest wielokrotnoci 10?
  if ($check % 10 != 0)
  {
    $_SESSION["{$errors}"]["{$field}"] = 
      "Numer karty kredytowej jest nieprawidowy. Prosz sprawdzi numer karty.";
    return false;
  }
  return true;
}

// Sprawdzenie daty wanoci karty kredytowej.
function checkExpiry($field, $errors, $formVars)
{
   if (!ereg("^([0-9]{2})/([0-9]{2})$", 
             $_SESSION["{$formVars}"]["{$field}"], $parts))
   {
      $_SESSION["{$errors}"]["{$field}"] = 
         "Data wanoci nie jest w formacie MM/YY";
      return false;
   }

   // Sprawdzenie miesica
   if (!is_numeric($parts[1]) ||
       intval($parts[1]) < 1 || 
       intval($parts[1]) > 12)
   {
      $_SESSION["{$errors}"]["{$field}"] = 
         "Miesic jest nieprawidowy.";
      return false;
   }

   // Sprawdzenie daty
   if (!is_numeric($parts[2]) || 
       // Czy min ju podany rok?
       intval($parts[2]) < intval(date("y")) || 
       // Rok biecy, czy min podany miesic?
       (intval($parts[2]) == intval(date("y")) && 
        intval($parts[1]) < intval(date("n"))) || 
       // Wicej ni 10 lat w przd?
       intval($parts[2]) > (intval(date("y")) + 10))
   {
      $_SESSION["{$errors}"]["{$field}"] = 
         "Data jest nieprawidowa.";
      return false;
   }
   
   return true;
}
?>
