<?php
require "db.inc";

// Zwraca biecy czas w postaci liczby. Wykorzystywana do zapisywania
// ostatniego odwoania do sesji.

function getMicroTime()
{
  // microtime( ) zwraca liczb sekund od 
  // 0:00:00 1 stycznia 1970 GMT w postaci mikrosekund

  // Konwertuje obie czci na tablic
  $mtime = explode(" ", microtime());

  // Zwraca sum obu czci, np. 1000952237.08344800
  return($mtime[1] + $mtime[0]);
}

// Poczenie z baz danych
$connection = NULL;
  
// Zmienna globalna zawierajca nazw tabeli
$session_table = NULL;

// Funkcja obsugi sesji wywoywana przez PHP w czasie 
// inicjalizacji sesji. Zawsze zwraca TRUE

function sessionOpen($database_name, $table_name)
{
  // Zapisanie poczenia z baz danych w zmiennej globalnej.
  global $connection;

  // Zapisanie nazwy tablicy sesji w zmiennej globalnej.
  global $session_table;

  // Dane potrzebne do zalogowania do bazy danych.
  global $hostName;
  global $username;
  global $password;

  if (!($connection = @ mysql_connect($hostName, $username, $password)))
     showerror();

  if (!mysql_select_db($database_name, $connection))
     showerror();

  $session_table = $table_name;

  return true;
}

// Funkcja wywoywana przez session_start() w celu odczytania wartoci zmiennych sesji
// identyfikowanej przez parametr $sess_id parameter. Zwraca "", gdy sesja nie zostanie znaleziona
// a jeeli zostanie odnaleziona, zmienne sesji w postaci cigu serializowanego.

function sessionRead($sess_id)
{
  // Dostp do poczenia z baz danych.
  global $connection;

  // Dostp do tabeli sesji.
  global $session_table;

  // Zapytanie wyszukujce sesj identyfikowan przez $sess_id
  $search_query = "SELECT * FROM {$session_table}
                   WHERE session_id = '{$sess_id}'";

  // Wykonanie zapytania.
  if (!($result = @mysql_query($search_query, $connection)))
     showerror();

  if(mysql_num_rows($result) == 0)
    // Nie znaleziono sesji - zwracany pusty cig.
    return "";
  else
  {
    // Znaleziono sesj - zwracany jest cig serializowany.
    $row = mysql_fetch_array($result);
    return $row["session_variable"];
  }
}

function sessionWrite($sess_id, $val)
{
  // Dostp do poczenia z baz danych.
  global $connection;

  // Dostp do tabeli sesji.
  global $session_table;

  $time_stamp = getMicroTime();

  $search_query = "SELECT session_id FROM {$session_table}
                   WHERE session_id = '{$sess_id}'";

  // Wykonanie zapytania.
  if (!($result = @mysql_query($search_query, $connection)))
     showerror();

  if(mysql_num_rows($result) == 0)
  {
     // Nie znaleziono sesji, wstawienie nowego wiersza.
     $insert_query = "INSERT INTO {$session_table}
                      (session_id, session_variable, last_accessed)
                      VALUES ('{$sess_id}', '{$val}', {$time_stamp})";

     if (!mysql_query($insert_query, $connection))
        showerror();
  }
  else
  {
     // Znaleziono sesj - aktualizacja zmiennych sesji.
     $update_query = "UPDATE {$session_table}
                      SET session_variable = '{$val}',
                          last_accessed = {$time_stamp}
                      WHERE session_id = '{$sess_id}'";

     if (!mysql_query($update_query, $connection))
        showerror();
  }
}

// Funkcja jest wykonywana przy zakoczeniu sesji.
// Zawsze zwraca true

function sessionClose()
{
    return true;
}

// Funkcja wywoywana przez  session_destroy( ) .
// Zwraca true jeeli sesja zostaa usunita.

function sessionDestroy($sess_id)
{
  // Dostp do poczenia z baz danych.
  global $connection;

  // Dostp do tabeli sesji.
  global $session_table;

  $delete_query = "DELETE FROM {$session_table}
                   WHERE session_id = '{$sess_id}'";

  if (!($result = @ mysql_query($delete_query, $connection)))
     showerror();

  return true;
}

// Funkcja wywoywana w czasie uruchamiania sesji
// z prawdopodobiestwem session.gc_probability. Wykonuje 
// oczyszczanie pamici usuwajc wszystkie sesje, ktre
// nie byy aktualizowane w ostatnich $max_lifetime sekundach.
// Zwraca TRUE, jeeli zapytanie DELETE zostao prawidowo wykonane.

function sessionGC($max_lifetime)
{
  // Dostp do poczenia z baz danych.
  global $connection;

  // Dostp do tabeli sesji.
  global $session_table;

  $current_time = getMicroTime();

  $delete_query = "DELETE FROM {$session_table}
             WHERE last_accessed < ({$current_time} - {$max_lifetime})";

  if (!($result = @ mysql_query($delete_query, $connection)))
     showerror();

  return true;
}

// Wywoanie funkcji wywoania zwrotnego definiowanych przez uytkownika.
session_set_save_handler("sessionOpen", 
                         "sessionClose", 
                         "sessionRead", 
                         "sessionWrite", 
                         "sessionDestroy", 
                         "sessionGC");
?>
