<?php include_once $_SERVER['DOCUMENT_ROOT'] .
    '/includes/helpers.inc.php'; ?>
<!DOCTYPE html>
<html lang="pl">
  <head>
    <meta charset="utf-8">
    <title>Katalog produktów</title>
    <style>
    table {
      border-collapse: collapse;
    }
    td, th {
      border: 1px solid black;
    }
    </style>
  </head>
  <body>
    <p>Liczba produktów w koszyku: <?php
        echo count($_SESSION['cart']); ?>.</p>
    <p><a href="?cart">Wyświetl zawartość koszyka</a></p>
    <table border="1">
      <thead>
        <tr>
          <th>Opis produktu</th>
          <th>Cena</th>
        </tr>
      </thead>
      <tbody>
        <?php foreach ($items as $item): ?>
          <tr>
            <td><?php htmlout($item['desc']); ?></td>
            <td>
               <?php echo number_format($item['price'], 2, ",", "."); ?> BTC
            </td>
            <td>
              <form action="" method="post">
                <div>
                  <input type="hidden" name="id" value="<?php
                      htmlout($item['id']); ?>">
                  <input type="submit" name="action" value="Kup">
                </div>
              </form>
            </td>
          </tr>
        <?php endforeach; ?>
      </tbody>
    </table>
    <p>Wszystkie ceny podajemy w fikcyjnych bitcoinach.</p>
  </body>
</html>
