<?php
define("LOGIN_OK", 1);
define("LOGIN_FAILED", 2);
define("SERVER_ERROR", 3);

class Portal
{
  private $dbo = null;
  function initDB($host, $user, $pass, $db)
  {
    $this->dbo = new mysqli($host, $user, $pass, $db);
    if($this->dbo->connect_errno){
      $msg = "Brak połączenia z bazą danych: ";
      $msg .= $this->dbo->connect_error;
      throw new Exception($msg);
    }
  }
  function getQuerySingleResult($query)
  {
    //Brak obiektu $dbo
    if(!$this->dbo) return false;
    
    //Wykonanie zapytania.
    if(!$result = $this->dbo->query($query)){
      //echo 'Wystąpił błąd (getQuerySingleResult): nieprawidłowe zapytanie...';
      return false;
    }
    if($row = $result->fetch_row()){
      //Zwrócenie wyniku.
      return $row[0];
    }
    else{
      //Brak wyników zapytania.
      return false;
    }
  }
  function getQueryResultAsTableRows($query, $colNames = false)
  {
    //Brak obiektu $dbo
    if(!$this->dbo) return false;
    
    //Odrzucone zapytanie
    if(!$result = $this->dbo->query($query)) return false;
    if(!$columns = $result->fetch_fields()) return false;
    
    //Zmienna przechowująca wynik działania metody.
    $str = '';
    
    //Uzyskanie nazw kolumn, o ile potrzebne.
    if($colNames){
      $str .= '<tr>';
      foreach($columns as $col){
        $str .= '<td>' . $col->name . '</td>';
      }
      $str .= '</tr>';
    }
    
    //Uzyskanie wyników zapytania.
    while($row = $result->fetch_row()){
      $str .= "<tr>";
      foreach($row as $val){
        $str .= "<td>$val</td>";
      }
      $str .= "</tr>";
    }
    
    //Zwrócenie ostatecznego wyniku.
    return $str;
  }
  function getUserInfo()
  {
    if(isset($_SESSION['zalogowany'])){
      $str = "Jesteś zalogowany jako: $_SESSION[zalogowany]<br />";
      $str .= "<a href=\"logout.php\">Wylogowanie</a>";
    }
    else{
      $str = "Nie jesteś zalogowany.<br />";
      $str .= "<a href=\"index.php?action=showLoginForm\">Logowanie</a>";
    }
    return $str;
  }
  function getRegUsersOnline($timeout)
  {
    if(!$this->dbo) return false;
    
    $query = "SELECT COUNT(*) FROM Stats WHERE Data > ";
    $query .= "DATE_SUB(NOW(), INTERVAL $timeout MINUTE) ";
    $query .= "AND UserId <> 0";

    return $this->getQuerySingleResult($query);
  }
  function getAllUsersOnline($timeout)
  {
    if(!$this->dbo) return false;
  
    $query = "SELECT COUNT(*) FROM Stats WHERE DATA > ";
    $query .= "DATE_SUB(NOW(), INTERVAL $timeout MINUTE)";
    
    return $this->getQuerySingleResult($query);
  }
  function getShortStats($timeout)
  {
    $regUsers = $this->getRegUsersOnline($timeout);
    $allUsers = $this->getAllUsersOnline($timeout);
    if($regUsers === false || $allUsers === false){
      return "Statystyki nie są dostępne.";
    }
    else{
      $msg = "W ciągu ostatnich $timeout minut stronę odwiedziło ";
      $msg .= "$allUsers gości, w tym $regUsers zarejestrowanych ";
      $msg .= "użytkowników. ";
      return $msg;
    }
  }
  function getFullStats()
  {
    if(!$this->dbo) return "Statystki nie są dostępne.";
  
    //Weryfikacja danych
    $ile = -1;
    if(isset($_GET['ile'])){
      $ile = intval($_GET['ile']);
      if($ile >= -1){
        if($ile == 0){
          //Czy zostały przekazane daty?
          if(isset($_GET['dataOd']) && isset($_GET['dataDo'])){
            //Czy daty odpowiadają formatowi?
            if(!preg_match("/^[0-9]{8}$/", $_GET['dataOd']) ||
               !preg_match("/^[0-9]{8}$/", $_GET['dataDo'])){
              //Niezgodność formatu.
              $ile = -1;
            }
            else{
              //Odczytanie dat.
              $dataOd = $_GET['dataOd'];
              $dataDo = $_GET['dataDo'];
            }
          }
          //Brak dat przy zaznaczonej opcji zakresu.
          else{
            $ile = -1;
          }
        }
        else{
          //Ustalenie maksymalnej dopuszczzalnej liczby dni.
          if($ile > 3660) $ile = 3660;
        }
      }
      //Parametr ile był nieprawidłowy.
      else{
       $ile = -1;
      } 
    }
    
    //Formowanie warunków zapytań i nagłówka tabeli.
    if($ile == 0){
      //Dodanie warunku dotyczącego dat.
      $cond = " WHERE Data >= '$dataOd' AND Data <= '$dataDo' ";
      $statsInfo = "Statystyki z okresu $dataOd do $dataDo.";
    }
    else if($ile > 0){
      //Dodanie warunku dotyczącego wybranego okresu.
      $cond = " WHERE Data > DATE_SUB(NOW(), INTERVAL $ile DAY) ";
      $statsInfo = "Statystyki z ostatnich $ile dni.";
    }
    else{
      //Dodanie pustego warunku.
      $cond = ' WHERE 1=1 ';
      $statsInfo = "Pełne statystyki";
    }
    
    //Pobieranie liczby odwiedzin.
    $query = "SELECT COUNT(*) AS Ile FROM Stats ";
    $allVisits = $this->getQuerySingleResult(
      $query . $cond );
    $regVisits = $this->getQuerySingleResult(
      $query . $cond . 'AND UserId <> 0 ');
    $allVisits = intval($allVisits);
    $regVisits = intval($regVisits);
    $guestVisits = $allVisits - $regVisits;
    
    //Pobieranie statystyk przeglądarek.
    $query = "SELECT Nazwa, COUNT(*) AS Ile FROM Stats, Przegladarki ";
    $query .= $cond;
    $query .= " AND Stats.BrowserId = Przegladarki.Id ";
    $query .= "GROUP BY BrowserId";
    
    $browsersInfo = $this->getQueryResultAsTableRows($query);

    //Pobieranie statystyk systemów.
    $query = "SELECT Nazwa, COUNT(*) AS Ile FROM Stats, Systemy ";
    $query .= $cond;
    $query .= " AND Stats.SystemId = Systemy.Id ";
    $query .= "GROUP BY SystemId";

    $systemsInfo = $this->getQueryResultAsTableRows($query);
    
    //Najczęściej logujący się użytkownicy.
    $query = "SELECT Nazwa, COUNT(*) AS Ile FROM Stats, Users ";
    $query .= $cond;
    $query .= " AND Stats.UserId = Users.Id AND Users.Id <> 0 ";
    $query .= "GROUP BY UserId LIMIT 10";

    $activeUsers = $this->getQueryResultAsTableRows($query);
    
    //Najczęściej występujące adresy IP.
    $query = "SELECT IP, COUNT(*) AS Ile FROM Stats ";
    $query .= $cond;
    $query .= "GROUP BY Ip LIMIT 10";
    
    $ips = $this->getQueryResultAsTableRows($query);
    
    //Adresy IP i daty ostatnich 10 połączeń.
    $query = "SELECT IP, Data FROM Stats ";
    $query .= $cond;
    $query .= "ORDER BY Data DESC LIMIT 10";
    
    $lastips = $this->getQueryResultAsTableRows($query);
    
    include 'statTable.php';
    return $result;
  }

  function login()
  {
    if(!$this->dbo) return SERVER_ERROR;
    
    //Sprawdzenie czy zostały przekazane parametry.
    if(!isset($_POST["user"]) || !isset($_POST["haslo"])){
      return LOGIN_FAILED;
    }
    
    $user = $_POST["user"];
    $pass = $_POST["haslo"];
    
    //Sprawdzenie długości przekazanych ciągów.
    //Dla kodowania jednobajtowego
    //$userNameLength = strlen($user);
    //$userPassLength = strlen($pass);
    //Dla kodowania utf-8
    $userNameLength = strlen(utf8_decode($user));
    $userPassLength = strlen(utf8_decode($pass));
    
    if($userNameLength < 3 || $userNameLength > 20 ||
     $userPassLength < 6 || $userPassLength > 40){
      return LOGIN_FAILED;
    }
  
    //Zabezpieczenie znaków specjalnych w parametrach.
    $user = $this->dbo->real_escape_string($user);
    $pass = $this->dbo->real_escape_string($pass);
    
    //Wykonanie zapytania sprawdzającego poprawność danych.
    $query = "SELECT Haslo, Nazwa, Id ";
    $query .= "FROM Users WHERE Nazwa='$user'";

    if(!$result = $this->dbo->query($query)){
      //echo 'Wystąpił błąd: nieprawidłowe zapytanie...';
      return SERVER_ERROR;
    }

    //Sprawdzenie wyników zapytania.
    if($result->num_rows <> 1){
      //Brak użytkownika o wskazanej nazwie lub zbyt wiele wyników.
      return LOGIN_FAILED;
    }
    else{
      $row = $result->fetch_row();
      $pass_db = $row[0];
      //Wersja bez kodowania haseł.
      //if($pass != $pass_db){
      //Wersja z kodowaniem haseł.
      if(crypt($pass, $pass_db) != $pass_db){
        return LOGIN_FAILED;
      }
      else{
        $_SESSION['zalogowany'] = $row[1];
        if(isset($_SESSION['statRecordId']) && 
                ($_SESSION['statRecordId'] > 0)){
          $this->updateStatRecord($_SESSION['statRecordId'], $row[2]);
        }
        else{
          $_SESSION['statRecordId'] = $this->addStatRecord($row[2]);
        }
        return LOGIN_OK;
      }
    }
  }
  function logout()
  {
    if(isset($_SESSION['zalogowany'])){
      unset($_SESSION['zalogowany']);
      $_SESSION['statRecordId'] = -1;
      /*
      //Jeśli sesja ma być usunięta:
      unset($_SESSION['statRecordId']);
      if (isset($_COOKIE[session_name()])){
        setcookie(session_name(), '', time() - 3600);
      }
      session_destroy();
      */
    }
  }
  
  function addStatRecord($userId)
  {
    if(!$this->dbo) return 0;
    
    $browser = get_browser();
  
    //Pobranie identyfikatora przeglądarki (jeśli istnieje).
    $browserName = $this->dbo->real_escape_string($browser->browser);
    $query = "SELECT id FROM Przegladarki WHERE Nazwa='$browserName'";
    
    if(($browserId = $this->getQuerySingleResult($query)) === false){
      //Jezeli nie ma przeglądarki w bazie, dodanie nowego wpisu.
      $query = "INSERT INTO Przegladarki VALUES(NULL,'$browserName')";
      if(!$result = $this->dbo->query($query)){
        return 0;
      }
      //Pobranie identyfikatora nowego wpisu.
      $browserId = $this->dbo->insert_id;
    }
    
    //Pobranie identyfikatora systemu (jeśli istnieje).
    $systemName = $this->dbo->real_escape_string($browser->platform);
    $query = "SELECT id FROM Systemy WHERE Nazwa = '$systemName'";
    
    if(($systemId = $this->getQuerySingleResult($query)) === false){
      //Jezeli nie ma systemu w bazie, dodanie nowego wpisu.
      $query = "INSERT INTO Systemy VALUES(NULL, '$systemName')";
      if(!$result = $this->dbo->query($query)){
        return 0;
      }
      //Pobranie identyfikatora nowego wpisu.
      $systemId = $this->dbo->insert_id;
    }
    
    if(!$systemId || !$browserId) return 0;
        
    //Dodanie nowego wpisu do tabeli Stats.
    $ip = $_SERVER['REMOTE_ADDR'];
    $query = "INSERT INTO STATS VALUES(";
    $query .= "NULL, '$ip', NOW(), $systemId, $browserId, $userId)";

    //Jeżeli wystąpił błąd przy dodawaniu wpisu dotyczącego przeglądarki lub systemu.
    if(!$this->dbo->query($query)){
      //echo 'Rekord statystyk nie został dodany.';
      return 0;
    }
    //Zwrócenie identyfikatora nowego wpisu.
    return $this->dbo->insert_id;
  }
  function updateStatRecord($recordId, $userId)
  {
    if(!$this->dbo) return;
    
    $query = "UPDATE Stats SET UserId = $userId WHERE Id = $recordId";
    if(!$this->dbo->query($query)){
      //echo 'Nie udała się aktualizaja statystyk.';
    }
  }
}
?>