"use strict";

// Upewnij się, że dokument jest gotowy przed wykonaniem skryptów
jQuery(function($){

// Szybkie sprawdzenie, czy skrypt został poprawnie załadowany
console.log("Plik init.js został pomyślnie załadowany.");

// Plik, do którego mają być kierowane żądania AJAX
var processFile = "assets/inc/ajax.inc.php",

// Funkcje operujące na oknie modalnym
    fx = {

        // Sprawdza istnienie okna modalnego i zwraca jego kod lub
        // tworzy i zwraca nowe
        "initModal" : function() {
                // Jeżeli nie dopasowano elementu, właściwość length
                // będzie miała wartość 0
                if ( $(".modal-window").length==0 )
                {
                    // Utwórz element div, dodaj do niego klasę i
                    // umieść go wewnątrz elementu body
                    return $("<div>")
                            .hide()
                            .addClass("modal-window")
                            .appendTo("body");
                }
                else
                {
                    // Zwraca okno modalne, jeżeli istnieje
                    // w drzewie DOM
                    return $(".modal-window");
                }
            },

        // Wstawia okno do kodu HTML i płynnie je wyświetla
        "boxin" : function(data, modal) {
                // Utwórz warstwę maskującą treść strony, dodaj do niej
                // klasę i procedurę obsługi zdarzenia click, a następnie
                // umieść ją w elemencie body
                $("<div>")
                    .hide()
                    .addClass("modal-overlay")
                    .click(function(event){
                            // Usuń wydarzenie
                            fx.boxout(event);
                        })
                    .appendTo("body");

                // Wczytaj dane do okna modalnego i
                // umieść je w elemencie body
                modal
                    .hide()
                    .append(data)
                    .appendTo("body");

                // Pokaż płynnie okno i warstwę maskującą
                $(".modal-window,.modal-overlay")
                    .fadeIn("slow");
            },

        // Ukrywa płynnie okno i usuwa je z DOM
        "boxout" : function(event) {
                // Jeżeli element wywołujący tę funkcję
                // wyzwolił zdarzenie,
                // wstrzymaj domyślne działanie
                if ( event!=undefined )
                {
                    event.preventDefault();
                }

                // Usuń klasę active ze wszystkich odnośników
                $("a").removeClass("active");

                // Wygaś okno modalne i warstwę maskującą,
                // a następnie usuń oba elementy z DOM
                $(".modal-window,.modal-overlay")
                    .fadeOut("slow", function() {
                            $(this).remove();
                        }
                    );
            }

    };

// Wyświetl wydarzenie w oknie modalnym
$("body").on("click", "li>a", function(event){

        // Zapobiega załadowaniu pliku view.php
        event.preventDefault();

        // Dodaj klasę "active" do odnośnika
        $(this).addClass("active");

        // Pobierz łańcuch zapytania z atrybutu href odnośnika
        var data = $(this)
                        .attr("href")
                        .replace(/.+?\?(.*)$/, "$1");

        // Wyświetl w konsoli łańcuch zapytania
        console.log( data );

        // Sprawdź czy okno modalne istnieje i
        // wybierz je lub utwórz nowe
        var modal = fx.initModal();

        // Utwórz przycisk do zamykania okna
        $("<a>")
            .attr("href", "#")
            .addClass("modal-close-btn")
            .html("&times;")
            .click(function(event){
                        // Usuń okno modalne
                        fx.boxout(event);
                    })
            .appendTo(modal);

        // Pobierz informacje o wydarzeniach z bazy danych
        $.ajax({
                type: "POST",
                url: processFile,
                data: "action=event_view&" + data,
                success: function(data){
                        fx.boxin(data, modal);
                    },
                error: function(msg) {
                        modal.append(msg);
                    }
            });

    });

});