<?php

declare(strict_types=1);

/*
 * Włącz sesje w razie potrzeby
 * (pozwala uniknąć niechcianego ostrzeżenia, jeżeli sesja jest już aktywna).
 */
$status = session_status();
if ($status == PHP_SESSION_NONE){
    // Brak aktywnej sesji
    session_start();
}

/*
 * Załaduj niezbędne pliki
 */
include_once '../../../sys/config/db-cred.inc.php';

/*
 * Zdefiniuj stałe z pliku konfiguracyjnego
 */
foreach ( $C as $name => $val )
{
    define($name, $val);
}

/*
 * Utwórz tablicę dopuszczalnych wartości parametru action
 */
define('ACTIONS', array(
        'event_view' => array(
                'object' => 'Calendar',
                'method' => 'displayEvent'
            )
        )
    );

/*
 * Potrzebny obiekt PDO
 */
$dsn = "mysql:host=" . DB_HOST . ";dbname=" . DB_NAME;
$dbo = new PDO($dsn, DB_USER, DB_PASS);
$dbo->query("SET NAMES 'utf8'");

/*
 * Upewnij się, że wysłano token zabezpieczający przed atakiem typu CSRF i że
 * wartość parametru action żądania istnieje w zdefiniowanej wcześniej tablicy
 */
if ( isset(ACTIONS[$_POST['action']]) )
{
    $use_array = ACTIONS[$_POST['action']];
    $obj = new $use_array['object']($dbo);
    $method = $use_array['method'];

    /*
     * Sprawdź czy dostępny jest identyfikator wydarzenia i zweryfikuj jego poprawność
     */
    if ( isset($_POST['event_id']) )
    {
        $id = (int) $_POST['event_id'];
    }
    else { $id = NULL; }

    echo $obj->$method($id);
}

function __autoload($class_name)
{
    $filename = '../../../sys/class/class.'
        . strtolower($class_name) . '.inc.php';
    if ( file_exists($filename) )
    {
        include_once $filename;
    }
}

?>