<?php

declare(strict_types=1);

/*
 * Upewnij się, że został przekazany identyfikator wydarzenia
 */
if ( isset($_GET['event_id']) )
{
    /*
     * Upewnij się, że identyfikator jest liczbą całkowitą
     */
    $id = preg_replace('/[^0-9]/', '', $_GET['event_id']);

    /*
     * Jeżeli identyfikator nie jest poprawny, przekieruj użytkownika do strony głównej
     */
    if ( empty($id) )
    {
        header("Location: ./");
        exit;
    }
}
else
{
    /*
     * W przypadku braku identyfikatora przekieruj użytkownika do strony głównej
     */
    header("Location: ./");
    exit;
}

/*
 * Załaduj niezbędne pliki
 */
include_once '../sys/core/init.inc.php';

/*
 * Wyświetl nagłówek
 */
$page_title = "Zobacz wydarzenie";
$css_files = array("style.css", "admin.css");
include_once 'assets/common/header.inc.php';

/*
 * Ładuj kalendarz
 */
$cal = new Calendar($dbo);

?>

<div id="content">
<?php echo $cal->displayEvent($id) ?>

    <a href="./">&laquo; Powrót do kalendarza</a>
</div><!-- end #content -->

<?php

/*
 * Wyświetl stopkę
 */
include_once 'assets/common/footer.inc.php';

?>