<?php

declare(strict_types=1);

class MyClass
{
    private $prop1 = "Jestem właściwością klasy!";

    private static $count = 0;

    public function __construct()
    {
        echo 'Inicjalizacja klasy "', __CLASS__, '"!<br />';
    }

    public function __destruct()
    {
        echo 'Klasa "', __CLASS__, '" została zniszczona.<br />';
    }

    public function __toString()
    {
        echo "W metodzie toString: ";
        return $this->getProperty();
    }

    public function setProperty(string $newval)
    {
        $this->prop1 = $newval;
    }

    protected function getProperty(): string
    {
        return $this->prop1 . "<br />";
    }

    public static function getCount(): int
    {
        return self::$count;
    }

    public static function plusOne()
    {
        echo "Zmienna ma wartość " . ++self::$count . ".<br />";
    }
}

class MyOtherClass extends MyClass
{
    public function __construct()
    {
        parent::__construct();
        echo "Nowy konstruktor w " . __CLASS__ . ".<br />";
    }

    public function newMethod(): string
    {
        return "Z nowej metody w " . __CLASS__ . ".<br />";
    }

    public function callProtected()
    {
        return $this->getProperty();
    }
}

do
{
    // Wywołaj metodę plusOne bez tworzenia instancji klasy MyClass
    MyClass::plusOne();
} while ( MyClass::getCount() < 10 );

?>
