<?php
try {
    $db_file = 'kartoteka.db';

    // otwórz połączenie z bazą SQLite lub utwórz nowy plik dla bazy
    $db_pdo = new PDO('sqlite:'.__DIR__.'/'.$db_file);
    
    // włącz obsługę wyjątków dla obsługi interfejsu PDO
    $db_pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

    /* przygotowanie zapytania SQL */
    $stmt = $db_pdo->prepare("SELECT * FROM ksiazki WHERE id=:id");
    
    // sprawdź, czy przekazany parametr jest liczbą całkowitą
    if ($stmt->bindValue(':id', 1, PDO::PARAM_INT))
    {
        /* wykonaj przygotowane zapytanie SQL */
        $stmt->execute();
        print_r($stmt->fetch(PDO::FETCH_ASSOC));
    }

    $db_pdo = NULL; // zamknij połączenie z bazą

} catch (PDOException $e) {
    print "Błąd!: " . $e->getMessage();
    die();
}