<?php
try {
    $db_file = 'kartoteka.db';

    // otwórz połączenie z bazą SQLite lub utwórz nowy plik dla bazy
    $db_pdo = new PDO('sqlite:'.__DIR__.'/'.$db_file);
    
    // włącz obsługę wyjątków dla obsługi interfejsu PDO
    $db_pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

    // utwórz tabelę, jeśli nie została wcześniej utworzona
    $db_pdo->exec("
        CREATE TABLE IF NOT EXISTS ksiazki
        (
        id INTEGER PRIMARY KEY AUTOINCREMENT,
        autor TEXT DEFAULT '',
        tytul TEXT DEFAULT '',
        rok INTEGER DEFAULT 0,
        stron INTEGER DEFAULT 0
        );

        CREATE TABLE IF NOT EXISTS osoby
        (
        id INTEGER PRIMARY KEY AUTOINCREMENT,
        imie TEXT DEFAULT '',
        nazwisko TEXT DEFAULT ''
        );

        CREATE TABLE IF NOT EXISTS wypozyczenia
        (
        id INTEGER PRIMARY KEY AUTOINCREMENT,
        ksiazka INTEGER DEFAULT 0,
        osoba INTEGER DEFAULT 0,
        data TEXT DEFAULT ''
        );

        INSERT INTO ksiazki (autor, tytul, rok, stron) 
        VALUES ('J.R.R. Tolkien', 'Władca Pierścieni', 2012, 1280);
        INSERT INTO ksiazki (autor, tytul, rok, stron) 
        VALUES ('Dan Brown', 'Kod Leonarda Da Vinci', 2016, 456);
        INSERT INTO ksiazki (autor, tytul, rok, stron) 
        VALUES ('J.D. Salinger', 'Buszujący w zbożu', 2017, 304);
        INSERT INTO ksiazki (autor, tytul, rok, stron) 
        VALUES ('Stephen King', 'Mroczna Wieża VII', 2021, 768);

        INSERT INTO osoby (imie, nazwisko) VALUES ('Zofia', 'Nowakówna');
        INSERT INTO osoby (imie, nazwisko) VALUES ('Oskar', 'Milewski');
        INSERT INTO osoby (imie, nazwisko) VALUES ('Karina', 'Promyczek');
        INSERT INTO osoby (imie, nazwisko) VALUES ('Antoni', 'Iksiński');
        INSERT INTO osoby (imie, nazwisko) VALUES ('Natalia', 'Kornatowska');

        INSERT INTO wypozyczenia (ksiazka, osoba, data) 
            VALUES (1, 1, '2021-03-20');
        INSERT INTO wypozyczenia (ksiazka, osoba, data) 
            VALUES (1, 2, '2021-03-22');
        INSERT INTO wypozyczenia (ksiazka, osoba, data) 
            VALUES (2, 3, '2021-03-24');
        INSERT INTO wypozyczenia (ksiazka, osoba, data) 
            VALUES (3, 4, '2021-03-27');
        INSERT INTO wypozyczenia (ksiazka, osoba, data) 
            VALUES (4, 5, '2021-03-31');
    ");

    print "Baza danych SQLite została utworzona!".PHP_EOL;
    print "Zawartość bazy danych:".PHP_EOL;

    print PHP_EOL;
    print "KSIĄŻKI".PHP_EOL;
    print "ID\tAUTOR\t\tTYTUŁ\t\t\tROK\tSTRON".PHP_EOL;

    $wynik = $db_pdo->query("SELECT * FROM ksiazki ORDER BY id ASC;");
    while ($wiersz = $wynik->fetch()) {
        printf(
            "%d\t%s\t%s\t%d\t%d".PHP_EOL, 
            $wiersz['id'], $wiersz['autor'], $wiersz['tytul'], 
            $wiersz['rok'], $wiersz['stron']
        );
    }

    print PHP_EOL;
    print "OSOBY".PHP_EOL;
    print "ID\tIMIE\tNAZWISKO".PHP_EOL;

    $wynik = $db_pdo->query("SELECT * FROM osoby ORDER BY id ASC;");
    while ($wiersz = $wynik->fetch()) {
        printf(
            "%d\t%s\t%s".PHP_EOL, 
            $wiersz['id'], $wiersz['imie'], $wiersz['nazwisko']
        );
    } 

    print PHP_EOL;
    print "WYPOŻYCZENIA".PHP_EOL;
    print "ID\tDATA\t\tID KSIĄŻKI\tID OSOBY".PHP_EOL;

    $wynik = $db_pdo->query("SELECT * FROM wypozyczenia ORDER BY id ASC;");
    while ($wiersz = $wynik->fetch()) {
        printf(
            "%d\t%s\t%s\t\t%s".PHP_EOL,
            $wiersz['id'], $wiersz['data'], 
            $wiersz['ksiazka'], $wiersz['osoba']
        );
    }

    $db_pdo = NULL; // zamknij połączenie z bazą

} catch (PDOException $e) {
    print "Błąd!: " . $e->getMessage();
    die();
}