<!doctype html>
<head>
<meta charset="utf-8">
<title>Domowa biblioteka</title>
</head>
<body>
<h2>Lista książek</h2>
<ol>
<?php
try {
    $db_file = 'kartoteka.db';

    // otwórz połączenie z bazą SQLite lub utwórz nowy plik dla bazy
    $db_pdo = new PDO('sqlite:'.__DIR__.'/'.$db_file);
    
    // włącz obsługę wyjątków dla obsługi interfejsu PDO
    $db_pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

    /* przygotowanie zapytania SQL */
    $wynik = $db_pdo->query("SELECT autor, tytul FROM ksiazki ORDER BY id ASC;");
    
    // przetwórz pobrane rekordy i wydrukuj
    while ($wiersz = $wynik->fetch()) {
        printf(
            "<li>%s, \"%s\"</li>".PHP_EOL,
            $wiersz['autor'], $wiersz['tytul']
        );
    }

    $db_pdo = NULL; // zamknij połączenie z bazą

} catch (PDOException $e) {
    print "Błąd!: " . $e->getMessage();
    die();
}
?>
</ol>
</body>
</html>