<?php
use PHPMailer\PHPMailer\{PHPMailer, SMTP, Exception};
require_once __DIR__."/libs/vendor/autoload.php"; // autoloader

$smarty = new Smarty;

// definicja katalogów roboczych
$smarty->setTemplateDir('smarty/templates'); // szablony
$smarty->setCompileDir('smarty/templates_c');
$smarty->setCacheDir('smarty/cache');
$smarty->setConfigDir('smarty/configs');

// którą stronę wyświetlić?
$page = (isset($_REQUEST['page'])) ? trim(strip_tags($_REQUEST['page'])) : '';
$smarty->assign('page', $page);

require_once 'inc/db.class.php'; // obsługa bazy danych
require_once 'inc/game.class.php'; // obsługa gry Hangman
require_once 'inc/book.class.php'; // główna klasa projektu

define('E_SEND', false); // wysłać wiadomość z formularza na adres e-mail?

/*
 E_MYSQL  - baza badych MySQL
 E_SQLITE - baza badych SQLite
*/
$project = new MyBook(E_SQLITE); // tworzenie egzemplarza klasy

// wyświetlenie szablonu
switch ($page) 
{
    case 'books':
        // może czegoś szukasz?
        $search = 
            (isset($_POST['search'])) ? trim(strip_tags($_POST['search'])) : '';

        /* pobierz informacje o książkach */
        $books = $project->books(search: $search);
        $smarty->assign('books', $books); 
        $smarty->assign('search', $search);

        $smarty->assign('title', 'Lista książek');
        $smarty->display('books.tpl');
        break;

    case 'register':
        /* pobierz informacje o wypożyczeniach */
        $register = $project->register();
        $smarty->assign('register', $register);

        $smarty->assign('title', 'Wypożyczenia');
        $smarty->display('register.tpl');
        break;

    case 'about':
        $smarty->assign('title', 'O mnie');
        $smarty->display('about.tpl');
        break;

    case 'contact':
        // formularz kontaktowy
        if (
            isset($_POST['contactForm']) &&
            isset($_POST['name']) && $_POST['name'] != '' &&
            isset($_POST['email']) && $_POST['email'] != '' &&
            isset($_POST['message']) && $_POST['message'] != ''
        ) {
            // proste filtrowanie danych z formularza
            $name = trim(strip_tags($_POST['name']));
            $email = trim(strip_tags($_POST['email']));
            $message = trim(strip_tags($_POST['message']));

            $smarty->assign('contactForm', $name); 

            $write = 
            "===> Data: ".date("Y-m-d H:i:s").PHP_EOL.
            "Imię: ".$name.PHP_EOL.
            "E-mail: ".$email.PHP_EOL.
            "Wiadomość:\r\n".$message.PHP_EOL.
            "<===".PHP_EOL.PHP_EOL;

            // zapisz do pliku 
            file_put_contents ("messages.txt", $write, FILE_APPEND);
            
            // wyślij na adres e-mail
            if (E_SEND) {
                $mail = new PHPMailer(true);
                try {
                    $myEmail = 'moj@email.pl';
                    $myName = 'Ja';
                    
                    /* konfiguracja z uwierzytelnainiem SMTP */
                    $mail->isSMTP();
                    $mail->Host       = 'smtp.serwer.pl';
                    $mail->SMTPAuth   = true;
                    $mail->Username   = 'moj@email.pl';
                    $mail->Password   = 'hasło';
                    $mail->SMTPSecure = PHPMailer::ENCRYPTION_STARTTLS;
                    $mail->Port       = 587; 
                    
                    $mail->CharSet = 'UTF-8';
                    $mail->setFrom($myEmail, $myName);
                    $mail->addAddress($myEmail, $myName);
                    $mail->Subject = 'Wiadomość ze strony';
                    $mail->Body = $write;
                    $mail->send();
                } catch (Exception $e) {
                    $smarty->assign('contactError', "Wiadomość nie została wysłana.<br>Komunikat błędu: {$mail->ErrorInfo}");
                }
            }
        }
        $smarty->assign('title', 'Kontakt');
        $smarty->display('contact.tpl');
        break;

    case 'game':
        // tymczasowa tablica z informacjami o aktualnym stanie gry
        $progres = []; 
        $progres['letter'] = (isset($_POST['letter']) && $_POST['letter'] != '') ? $_POST['letter'] : '_';
        $progres['entered'] = (isset($_POST['entered']) && $_POST['entered'] != '') ? $_POST['entered'] : '';
        $progres['current'] = (isset($_POST['current']) && $_POST['current'] != '') ? (int)$_POST['current'] : -1;
        $progres['errors'] = (isset($_POST['errors']) && $_POST['errors'] != '') ? (int)$_POST['errors'] : 0; 

        // tytuły książek z bazy danych będą hasłami do odgadnięcia w grze
        $books = $project->books();
        foreach ($books as $book) {
            $progres['books'][] = $book['title'];
        }

        require_once 'inc/game.class.php';
        $hangman = new Hangman(
            texts: $progres['books'], 
            current: $progres['current'], 
            errors: $progres['errors']
        );

        // nowa gra czy kontynuacja?
        $game = (isset($_POST['game'])) ? $hangman->play($progres['letter'], $progres['entered']) : $hangman->start();

        $smarty->assign('title', 'Trochę rozrywki');
        $smarty->assign('game', $game);
        $smarty->display('game.tpl');
        break;

    default:
        $smarty->assign('title', 'Biblioteka Młodego Człowieka');
        $smarty->display('index.tpl');
}

unset($project);