<?php
require_once __DIR__."/libs/vendor/autoload.php"; // autoloader

$smarty = new Smarty;

// definicja katalogów roboczych
$smarty->setTemplateDir('smarty/templates'); // szablony
$smarty->setCompileDir('smarty/templates_c');
$smarty->setCacheDir('smarty/cache');
$smarty->setConfigDir('smarty/configs');

// którą stronę wyświetlić?
$page = (isset($_REQUEST['page'])) ? trim(strip_tags($_REQUEST['page'])) : '';
$smarty->assign('page', $page);

require_once 'inc/db.class.php'; // obsługa bazy danych
require_once 'inc/book.class.php'; // główna klasa projektu

/*
 E_MYSQL  - baza badych MySQL
 E_SQLITE - baza badych SQLite
*/
$project = new MyBook(E_MYSQL); // tworzenie egzemplarza klasy

// wyświetlenie szablonu
switch ($page) 
{
    case 'books':
        // może czegoś szukasz?
        $search = (isset($_POST['search'])) ? trim(strip_tags($_POST['search'])) : '';

        /* pobierz informacje o książkach */
        $books = $project->books(search: $search);
        $smarty->assign('books', $books); 
        $smarty->assign('search', $search);

        $smarty->assign('title', 'Lista książek');
        $smarty->display('books.tpl');
        break;

    case 'register':
        /* pobierz informacje o wypożyczeniach */
        $register = $project->register();
        $smarty->assign('register', $register);

        $smarty->assign('title', 'Wypożyczenia');
        $smarty->display('register.tpl');
        break;

    case 'about':
        $smarty->assign('title', 'O mnie');
        $smarty->display('about.tpl');
        break;

    case 'contact': 
        $smarty->assign('title', 'Kontakt');
        $smarty->display('contact.tpl');
        break;

    default:
        $smarty->assign('title', 'Biblioteka Młodego Człowieka');
        $smarty->display('index.tpl');
}

unset($project);