<?php
try {
    $db_file = 'UczestnicyBalu.db';

    // otwórz połączenie z bazą SQLite lub utwórz nowy plik dla bazy
    $db_pdo = new PDO('sqlite:'.__DIR__.'/'.$db_file);

    // włącz obsługę wyjątków dla obsługi interfejsu PDO
    $db_pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

    // wyślij zapytanie do bazy i pobierz wyniki
    $wynik = $db_pdo->query(
        "SELECT imie, wiek FROM UczestnicyBalu ORDER BY wiek ASC;"
    );

    $db_pdo = NULL; // zamknij połączenie z bazą
    
    // przetwórz pobrane rekordy i wydrukuj
    print "Uczestnicy balu:".PHP_EOL;
    while ($wiersz = $wynik->fetch()) {
        printf("Imię: %s, wiek: %d".PHP_EOL, $wiersz['imie'], $wiersz['wiek']);
    }
} catch (PDOException $e) {
    print "Błąd!: " . $e->getMessage();
    die();
}