<?php # Skrypt 16.11 - change_password.php
// Strona pozwalajca zalogowanemu uytkownikowi zmieni haso.

require_once ('includes/config.inc.php'); 
$page_title = 'Zmiana hasa';
include ('includes/header.html');

// Jesli uytkownik nie jest zalogowany, przekierowuje go.
if (!isset($_SESSION['first_name'])) {
	
	$url = BASE_URL . 'index.php'; // Definiuje URL.
	ob_end_clean(); // Oprnia bufor.
	header("Location: $url");
	exit(); // Koczy dziaanie skryptu.
	
}

if (isset($_POST['submitted'])) {
	require_once (MYSQL);
			
	// Sprawdza nowe haso i porwnuje je z potwierdzeniem.
	$p = FALSE;
	if (preg_match ('/^(\w){4,20}$/', $_POST['password1']) ) {
		if ($_POST['password1'] == $_POST['password2']) {
			$p = mysqli_real_escape_string ($dbc, $_POST['password1']);
		} else {
			echo '<p class="error">Naley dwukrotnie wpisa to samo haso!</p>';
		}
	} else {
		echo '<p class="error">Wpisz prawidowe haso!</p>';
	}
	
	if ($p) { // Jeli wszystko OK.

		// Wykonaj zapytanie.
		$q = "UPDATE users SET pass=SHA1('$p') WHERE user_id={$_SESSION['user_id']} LIMIT 1";	
		$r = mysqli_query ($dbc, $q) or trigger_error("Zapytanie: $q\n<br />Bd MySQL: " . mysqli_error($dbc));
		if (mysqli_affected_rows($dbc) == 1) { // Jeli zapytanie wykonane poprawnie.
		
			// Wylij tutaj e-mail, jeli uwaasz to za konieczne.
			echo '<h3>Haso zostao zmienione.</h3>';
			mysqli_close($dbc); // Zamyka poczenie z baz danych.
			include ('includes/footer.html'); // Docza stopk HTML .
			exit();
			
		} else { // Zapytanie nie dao spodziewanego wyniku.
		
			echo '<p class="error">Twoje haso nie zostao zmienione. Upewnij si, e nowe haso rni si od aktualnego. Skontaktuj si z administratorem systemu jeli uwaasz, e wystpi bd.</p>'; 

		}

	} else { // Kontrola hasa nie wypada pomylnie.
		echo '<p class="error">Sprbuj jeszcze raz.</p>';		
	}
	
	mysqli_close($dbc); // Zamyka poczenie z baz danych.

} // Koniec gwnej instrukcji warunkowej.

?>

<h1>Zmiana hasa</h1>
<form action="change_password.php" method="post">
	<fieldset>
	<p><b>Nowe haso:</b> <input type="password" name="password1" size="20" maxlength="20" /> <small>Haso musi zawiera od 4 do 20 znakw (tylko litery, cyfry i znak podkrelenia).</small></p>
	<p><b>Potwierdzenie hasa:</b> <input type="password" name="password2" size="20" maxlength="20" /></p>
	</fieldset>
	<div align="center"><input type="submit" name="submit" value="Zmiana hasa" /></div>
	<input type="hidden" name="submitted" value="TRUE" />
</form>

<?php
include ('includes/footer.html');
?>
