<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN"
        "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="en" lang="en">
<head>
	<meta http-equiv="content-type" content="text/html; charset=iso-8859-2" />
	<title>Kontakt</title>
</head>
<body>
<h1>Kontakt</h1>
<?php # Skrypt 12.1 - email.php #2

// Sprawdza czy formularz zosta wysany.
if (isset($_POST['submitted'])) {

	/* Ta funkcja ma jeden argument: acuch znakw.
	* Zwraca "bezpieczn" wersj acucha.
	* Moe by ni pusty acuch
	* lub acuch wejciowy po usuniciu wszystkich znakw nowego wiersza.
	*/
	function spam_scrubber($value) {
	
		// Lista niedozwolonych acuchw:
		$very_bad = array('to:', 'cc:', 'bcc:', 'content-type:', 'mime-version:', 'multipart-mixed:', 'content-transfer-encoding:');
		
		// Jeli acuch wejciowy zawiera ktrykolwiek 
                // z niedozwolonych acuchw
		// funkcja zwraca pusty acuch.
		foreach ($very_bad as $v) {
			if (stripos($value, $v) !== false) return '';
		}
		
		// Zastpuje spacjami znaki nowego wiersza.
		$value = str_replace(array( "\r", "\n", "%0a", "%0d"), ' ', $value);
		
		// Zwraca wynik.
		return trim($value);
	
	} // Koniec funkcji spam_scrubber().
	
	// "Oczyszcza" dane formularza.
	$scrubbed = array_map('spam_scrubber', $_POST);

	// Podstawowa weryfikacja danych formularza.
	if (!empty($scrubbed['name']) && !empty($scrubbed['email']) && !empty($scrubbed['comments']) ) {
	
		// Tworzy ciao wiadomoci e-mail.
		$body = "Nazwisko i imi: {$scrubbed['name']}\n\nUwagi: {$scrubbed['comments']}";
		$body = wordwrap($body, 70);
	
		// Wysya wiadomo.
		mail('your_email@example.com', 'Formularz kontaktowy', $body, "From: {$scrubbed['email']}");
		
		// Wywietla komunikat.
		echo '<p><em>Dzikujemy za przekazane uwagi. Odpowiemy wkrtce.</em></p>';
		
		// Zeruje tablic $_POST (aby formularz nie zachowywa wprowadzonych informacji):
		$_POST = array();
	
	} else {
		echo '<p style="font-weight: bold; color: #C00">Prosz wypeni wszystkie pola formularza.</p>';
	}
	
} // Koniec instrukcji if isset().
?>
<p>Wypenij poniszy formularz, aby si z nami skontaktowa.</p>
<form action="email.php" method="post">
	<p>Nazwisko i imi: <input type="text" name="name" size="30" maxlength="60" value="<?php if (isset($_POST['name'])) echo $_POST['name']; ?>" /></p>
	<p>Adres e-mail: <input type="text" name="email" size="30" maxlength="80" value="<?php if (isset($_POST['email'])) echo $_POST['email']; ?>" /></p>
	<p>Uwagi: <textarea name="comments" rows="5" cols="30"><?php if (isset($_POST['comments'])) echo $_POST['comments']; ?></textarea></p>
	<p><input type="submit" name="submit" value="Wylij!" /></p>
	<input type="hidden" name="submitted" value="TRUE" />
</form>
</body>
</html>
