<?php # Skrypt 9.3 - edytuj_uzytkownika.php

// Umoliwia edycj danych uytkownika.
// Wywoywana ze strony pokaz_uzytkownikow.php.


$page_title = 'Edycja uytkownika';
include ('includes/naglowek.html');

echo '<h1>Edytuj uytkownika</h1>';

// Sprawdza poprawno identyfikatora przekazanego za pomoc metody GET lub POST.
if ( (isset($_GET['id'])) && (is_numeric($_GET['id'])) ) { // Dostp ze strony pokaz_uzytkownikow.php
	$id = $_GET['id'];
} elseif ( (isset($_POST['id'])) && (is_numeric($_POST['id'])) ) { // Wysanie formularza.
	$id = $_POST['id'];
} else { // Brak poprawnego identyfikatora, zakocz skrypt.
	echo '<p class="error">Bd podczas dostpu do strony.</p>';
	include ('includes/stopka.html'); 
	exit();
}

require_once ('../mysqli_connect.php'); 

// Sprawd, czy formularz zosta wysany.
if (isset($_POST['submitted'])) {

	$errors = array();
	
	// Sprawd imi.
	if (empty($_POST['first_name'])) {
		$errors[] = 'Zapomniae wprowadzi swoje imi!';
	} else {
		$fn = mysqli_real_escape_string($dbc, trim($_POST['first_name']));
	}
	
	// Sprawd nazwisko.
	if (empty($_POST['last_name'])) {
		$errors[] = 'Zapomniae wprowadzi swoje nazwisko!';
	} else {
		$ln = mysqli_real_escape_string($dbc, trim($_POST['last_name']));
	}
	
	// Sprawd adres e-mail.
	if (empty($_POST['email'])) {
		$errors[] = 'Zapomniae wprowadzi adres e-mail.';
	} else {
		$e = mysqli_real_escape_string($dbc, trim($_POST['email']));
	}
	
	if (empty($errors)) { // Jeli formularz wypeniony poprawnie.
	
		//  Sprawd unikalno adresu email.
		$q = "SELECT user_id FROM users WHERE email='$e' AND user_id != $id";
		$r = @mysqli_query($dbc, $q);
		if (mysqli_num_rows($r) == 0) {

			// Utwrz zapytanie.
			$q = "UPDATE users SET first_name='$fn', last_name='$ln', email='$e' WHERE user_id=$id LIMIT 1";
			$r = @mysqli_query ($dbc, $q);
			if (mysqli_affected_rows($dbc) == 1) { // Jeli zapytanie wykonane poprawnie.
			
				// Wywietl komunikat.
				echo '<p>Dane uytkownika zostay zmienione.</p>';	
							
			} else { // W przeciwnym razie.
				echo '<p class="error">Dane uytkownika nie zostay zmienione ze wzgldu na bd systemu. Przepraszamy za utrudnienia.</p>'; // Komunikat dla uytkownika.
				echo '<p>' . mysqli_error($dbc) . '<br />Zapytanie: ' . $q . '</p>'; // Komunikat uruchomieniowy.
			}
				
		} else { // Ju zarejestrowany.
			echo '<p class="error">Podany adres e-mail jest ju zarejestrowany.</p>';
		}
		
	} else { // Raportuj bdy.
	
		echo '<p class="error">Wystpiy nastpujce bdy:<br />';
		foreach ($errors as $msg) { // Wywietl kady komunikat o bdzie.
			echo " - $msg<br />\n";
		}
		echo '</p><p>Sprbuj jeszcze raz.</p>';
		
	} // Koniec instrukcji warunkowej if (empty($errors)).

} // Koniec instrukcji warunkowej wysania formularza.

// Zawsze poka formularz.

// Pobierz informacje o uytkowniku.
$q = "SELECT first_name, last_name, email FROM users WHERE user_id=$id";		
$r = @mysqli_query ($dbc, $q);

if (mysqli_num_rows($r) == 1) { // Poprawny identyfikator uytkownika, wywietl formularz.


	// Pobierz informacje.
	$row = mysqli_fetch_array ($r, MYSQLI_NUM);
	
	// Utwrz formularz.
	echo '<form action="edytuj_uzytkownika.php" method="post">
<p>Imi: <input type="text" name="first_name" size="15" maxlength="15" value="' . $row[0] . '" /></p>
<p>Nazwisko: <input type="text" name="last_name" size="15" maxlength="30" value="' . $row[1] . '" /></p>
<p>Adres e-mail: <input type="text" name="email" size="20" maxlength="40" value="' . $row[2] . '"  /> </p>
<p><input type="submit" name="submit" value="Wylij" /></p>
<input type="hidden" name="submitted" value="TRUE" />
<input type="hidden" name="id" value="' . $id . '" />
</form>';

} else { // Niepoprawny identyfikator uytkownika.
	echo '<p class="error">Bd dostpu do strony.</p>';
}

mysqli_close($dbc);
		
include ('includes/stopka.html');
?>
