<?php # Skrypt 8.4 - pokaz_uzytkownikow.php
// Ten skrypt odczytuje wszystkie rekordy z tabeli users.

$page_title = 'Zobacz zarejestrowanych uytkownikw';
include ('includes/header.html');

// Nagwek strony.
echo '<h1>Zarejestrowani uytkownicy</h1>';

require_once ('../mysqli_connect.php'); // Pocz si z baz danych.
		
// Utwrz zapytanie.
$q = "SELECT CONCAT(last_name, ', ', first_name) AS name, DATE_FORMAT(registration_date, '%M %d, %Y') AS dr FROM users ORDER BY registration_date ASC";		
$r = @mysqli_query ($dbc, $q); // Wykonaj zapytanie.
if ($r) { // Jeeli zapytanie zostao wykonane poprawnie, poka rekordy.

	// Nagwek tabeli.
	echo '<table align="center" cellspacing="3" cellpadding="3" width="75%">
	<tr><td align="left"><b>Nazwisko</b></td><td align="left"><b>Data rejestracji</b></td></tr>
';
	
	// Pobierz i poka wszystkie rekordy.
	while ($row = mysqli_fetch_array($r, MYSQLI_ASSOC)) {
		echo '<tr><td align="left">' . $row['name'] . '</td><td align="left">' . $row['dr'] . '</td></tr>
		';
	}

	echo '</table>'; // Zamknij tabel.
	
	mysqli_free_result ($r); // Zwolnij zasoby.	

} else { // Jeeli zapytanie nie zostao  wykonane pomylnie
	// Komunikat dla uytkownika.
	echo '<p class="error">Nie moemy wyswietli listy uytkownikw ze  wzgldu na awari systemu.  Przepraszamy za kopot.</p>';
	
	// Komunikat uruchomieniowy.
	echo '<p>' . mysqli_error($dbc) . '<br /><br />Zapytanie: ' . $q . '</p>';
	
} // Koniec instrukcji if ($r).

mysqli_close($dbc); // Zamknij poczenie z  baz danych.

include ('includes/stopka.html');
?>
