<?php # Skrypt 15.8 - search.php
// Wywietla i obsuguje formularz wyszukiwania.

// Docza nagwek HTML.
include ('includes/naglowek.html');

// Wywietla formularz wyszukiwania.
echo '<form action="search.php" method="get" accept-charset="utf-8">
<p><em>' . $words['search'] . '</em>: <input name="terms" type="text" size="30" maxlength="60" ';
	
// Sprawdza czy wprowadzono sowo kluczowe.
if (isset($_GET['terms'])) {
	echo 'value="' . htmlspecialchars($_GET['terms']) . '" ';
}

// Koczy formularz.
echo '/><input name="submit" type="submit" value="' . $words['submit'] . '" /></p></form>';

if (isset($_GET['terms'])) { // Handle the form.

	// Oprnia pole wyszukiwania.
	$terms = mysqli_real_escape_string($dbc, htmlentities(strip_tags($_GET['terms'])));

	// Wykonuje zapytanie.
	$q = "SELECT * FROM languages WHERE lang_id = 100";
	$r = mysqli_query($dbc, $q);
	if (mysqli_num_rows($r) > 0) {
		echo '<h2>Wyniki wyszukiwania</h2>';
	} else {
		echo '<p>Nie znaleziono.</p>';
	}

}

// Docza stopk HTML.
include ('includes/stopka.html');
?>
