<?php # Skrypt 9.3 - login.php

// Strona przetwarzajca formularz logowania.
// Po pomylnym zalogowaniu, uytkownik zostaje przekierowany na stron loggedin.php.
// Strona docza dwa pliki.
// Nie wysyaj NICZEGO do przegldarki przed wywoaniem funkcji setcookie()!

// Sprawdza czy formularz zosta wysany.
if (isset($_POST['submitted'])) {

	// Docza funkcje zwizane z logowaniem.
	require_once ('includes/login_functions.inc.php');
	
	// Uywa poczenia z baz danych.
	require_once ('../mysqli_connect.php');
		
	// Prbuje uwierzytelni.
	list ($check, $data) = check_login($dbc, $_POST['email'], $_POST['pass']);
	
	if ($check) { // OK!
			
		// Tworzy cookies.
		setcookie ('user_id', $data['user_id']);
		setcookie ('first_name', $data['first_name']);
		
		// Przekierowuje.
		$url = absolute_url ('loggedin.php');
		header("Location: $url");
		exit(); // Koczy dziaanie skryptu.
			
	} else { // Niepowodzenie!

		// Przypisuje $data do $errors w celu raportowania bdw
		// przez stron login_page.inc.php.
		$errors = $data;

	}
		
	mysqli_close($dbc); // Zamyka poczenie z baz danych.

} // Koniec gwnej instrukcji warunkowej.

// Tworzy stron logowania.
include ('includes/login_page.inc.php');
?>
