<?php # Skrypt 11.2 - login_functions.inc.php

// Definiuje dwie funkcje uywane w procesie logowania/wylogowania.

/* Funkcja okrelajca i zwracajca absolutny adres URL.
 * Ma jeden argument: nazw strony koczc adres URL.
 * Domyln wartosci argumentu jest index.php.
 */
function absolute_url ($page = 'index.php') {

	// Pocztek definiowania adresu URL.
	// URL = http:// + nazwa hosta  + biecy katalog.
	$url = 'http://' . $_SERVER['HTTP_HOST'] . dirname($_SERVER['PHP_SELF']);
	
	// Usuwa ukoniki na kocu acucha.
	$url = rtrim($url, '/\\');
	
	// Docza nazw strony.
	$url .= '/' . $page;
	
	// Zwraca adres URL.
	return $url;

} // Koniec funkcji absolute_url() .


/* Funkcja weryfikujca dane wprowadzone w formularzu (adres e-mail i haso).
 * Jeli obie wartoci zostay wprowadzone, wysya zapytanie do bazy danych.
 * Funkcja wymaga przekazania jej poczenia z baz danych.
 * Zwraca tablic zawierajc:
 * - warto TRUE lub FALSE oznaczajc wynik logowania
 * - tablic bdw lub danych pobranych z bazy
 */
function check_login($dbc, $email = '', $pass = '') {

	$errors = array(); // Inicjuje tablic bdw.
	
	// Sprawdza adres e-mail.
	if (empty($email)) {
		$errors[] = 'Zapomniae wprowadzi adres e-mail.';
	} else {
		$e = mysqli_real_escape_string($dbc, trim($email));
	}
	
	// Sprawdza haso. 
	if (empty($pass)) {
		$errors[] = 'Zapomniae poda haso.';
	} else {
		$p = mysqli_real_escape_string($dbc, trim($pass));
	}

	if (empty($errors)) { // Jeli brak bdw.

		// Pobiera pola user_id i first_name dla podanej kombinacji adresu e-mail i hasa.		$q = "SELECT user_id, first_name FROM users WHERE email='$e' AND pass=SHA1('$p')";		
		$r = @mysqli_query ($dbc, $q); // Wykonuje zapytanie.
		
		// Sprawdza wynik.
		if (mysqli_num_rows($r) == 1) {
		
			// Pobiera rekord.
			$row = mysqli_fetch_array ($r, MYSQLI_ASSOC);
			
			// Zwraca warto true i rekord.
			return array(true, $row);
			
		} else { // Niepoprawne dane,
			$errors[] = 'Wprowadzone adres i haso nie odpowiadaj przechowywanym w bazie danych.';
		}
		
	} // Koniec instrukcji if empty($errors) .
	
	// Zwraca warto false i tablic bdw.
	return array(false, $errors);

} // Koniec funkcji check_login().

?>
