<?php # Skrypt 8.7 - zmiana_hasla.php
// Umoliwia zmian hasa.

$page_title = 'Zmie swoje haso';
include ('includes/naglowek.html');

// Sprawd, czy formularz zosta     wysany.
if (isset($_POST['submitted'])) {

	require_once ('../mysqli_connect.php'); // Pocz si z baz danych.
		
	$errors = array(); // Zainicjuj tablic bdw.
	
	// Sprawd adres e-mail.
	if (empty($_POST['email'])) {
		$errors[] = 'Zapomniae poda swj adres e-mail!';
	} else {
		$e = mysqli_real_escape_string($dbc, trim($_POST['email']));
	}
	
	// Sprawd, czy uytkownik wprowadzi dotychczasowe haso.
	if (empty($_POST['pass'])) {
		$errors[] = 'Zapomniae wprowadzi dotychczasowe haso!';
	} else {
		$p = mysqli_real_escape_string($dbc, trim($_POST['pass']));
	}

	// Sprawd, czy uytkownik wprowadzi w obu polach takie samo haso.
	if (!empty($_POST['pass1'])) {
		if ($_POST['pass1'] != $_POST['pass2']) {
			$errors[] = 'Za drugim razem wpisae inne haso!';
		} else {
			$np = mysqli_real_escape_string($dbc, trim($_POST['pass1']));
		}
	} else {
		$errors[] = 'Zapomniae wprowadzi nowe haso!';
	}
	
	if (empty($errors)) { // Jeli formularz wypeniony bez bdw.
	
		// Sprawd, czy zostaa wprowadzona poprawna kombinacja e-mail/haso.
		$q = "SELECT user_id FROM users WHERE (email='$e' AND pass=SHA1('$p') )";
		$r = @mysqli_query($dbc, $q);
		$num = @mysqli_num_rows($r);
		if ($num == 1) { // Poprawna.
		
			// Pobierz user_id:
			$row = mysqli_fetch_array($r, MYSQLI_NUM);

			// Utwrz zapytanie UPDATE.
			$q = "UPDATE users SET pass=SHA1('$np') WHERE user_id=$row[0]";		
			$r = @mysqli_query($dbc, $q);
			
			if (mysqli_affected_rows($dbc) == 1) { // Jeeli zapytanie zostao wykonane poprawnie.
			
				// Wywietl komunikat.
				echo '<h1>Dzikujemy!</h1>
				<p>Haso zostao zmienione. W rozdziale 11. bdziesz mg si zalogowa!</p><p><br /></p>';	
			
			} else { // Jeeli zapytanie nie zostao wykonane poprawnie.
			
				// Komunikat dla uytkownika.
				echo '<h1>Bd systemu</h1>
				<p class="error">Haso nie zostao zmienione z powodu awarii naszego systemu. Przepraszamy za kopot.</p>'; 
				
				// Komunikat uruchomieniowy.
				echo '<p>' . mysqli_error($dbc) . '<br /><br />Zapytanie: ' . $q . '</p>';
				
			}

			// Docz stopk i zakocz skrypt (aby nie wywietli formularza).
			include ('includes/stopka.html'); 
			exit();
				
		} else { // Niepoprawna kombinacja e-mail/password.
			echo '<h1>Bd!</h1>
			<p class="error">Podae niewaciwy adres e-mail bd haso.</p>';
		}
		
	} else { // Raportuj bdy.
	
		echo '<h1>Bd!</h1>
		<p class="error">Wystpiy nastpujce bdy:<br />';
		foreach ($errors as $msg) { // Wywietl kady komunikat o bdzie.
			echo " - $msg<br />\n";
		}
		echo '</p><p>Sprbuj jeszcze raz.</p><p><br /></p>';
		
	} // Koniec instrukcji warunkowej if (empty($errors)) 

	mysqli_close($dbc); // Zamknij poczenie z baz danych.
		
} // Koniec gwnej instrukcji warunkowej (wysania formularza).
?>
<h1>Zmie haso</h1>
<form action="zmiana_hasla.php" method="post">
	<p>Adres e-mail: <input type="text" name="email" size="20" maxlength="80" value="<?php if (isset($_POST['email'])) echo $_POST['email']; ?>"  /> </p>
	<p>Aktualne haso: <input type="password" name="pass" size="10" maxlength="20" /></p>
	<p>Nowe haso: <input type="password" name="pass1" size="10" maxlength="20" /></p>
	<p>Potwierd nowe haso: <input type="password" name="pass2" size="10" maxlength="20" /></p>
	<p><input type="submit" name="submit" value="Zmie moje haso!" /></p>
	<input type="hidden" name="submitted" value="TRUE" />
</form>
<?php
include ('includes/stopka.html');
?>
