use Test::More tests => 18;
use Test::Exception;
use Test::Deep;

use strict;
use warnings;

BEGIN
{
   use_ok('Scorekeeper');
}

my $a = Scorekeeper::Player->create( { name => 'GraczA' } );
my $b = Scorekeeper::Player->create( { name => 'GraczB' } );
my $c = Scorekeeper::Player->create( { name => 'GraczC' } );

END
{
   foreach my $player ( $a, $b, $c )
   {
      $player->games->delete_all(  );
      $player->delete(  );
   }
}

dies_ok { Scorekeeper::Player->create( { name => $a->name(  ) } ) } 'nie mona utworzy dwch graczy o tym samym imieniu';

foreach my $tuple ( [ 11, 8 ], [ 9, 11 ], [ 11, 7 ], [ 10, 11 ], [ 11, 9 ] )
{
   my ( $score1, $score2 ) = @$tuple;

   my $g = Scorekeeper::Game->create( {  } );
   $g->add_to_scores( { player => $a, value => $score1 } );
   $g->add_to_scores( { player => $b, value => $score2 } );
}

my $g2 = Scorekeeper::Game->create( {  } );
$g2->add_to_scores( { player => $a, value => 11 } );
$g2->add_to_scores( { player => $c, value => 8 } );

is( scalar( $a->games(  ) ), 6 );
is( scalar( $b->games(  ) ), 5 );

is( $a->wins(  ),   4, "wygrane gracza A"   );
is( $b->wins(  ),   2, "wygrane gracza B"   );
is( $c->wins(  ),   0, "wygrane gracza C"   );

is( $a->losses(  ), 2, "poraki gracza A" );
is( $b->losses(  ), 3, "poraki gracza B" );
is( $c->losses(  ), 1, "poraki gracza C" );

cmp_deeply( [ $a->opponents(  ) ], bag( $b, $c ), "przeciwnicy gracza A" );
is_deeply(  [ $b->opponents(  ) ], [$a],  "przeciwnicy gracza B" );
is_deeply(  [ $c->opponents(  ) ], [$a],  "przeciwnicy gracza C" );

is( $a->winning_percentage_against($b), 60,  'A vs B' );
is( $b->winning_percentage_against($a), 40,  'B vs A' );

is( $a->winning_percentage_against($c), 100, 'A vs C' );
is( $c->winning_percentage_against($a), 0,   'C vs A' );

is_deeply(
   [ Scorekeeper::Player->retrieve_all_ranked(  ) ],
   [ $a, $b, $c ],
   'gracze pobrani zgodnie z kolejnoci w rankingu'
);
