#!perl

use lib 'lib';

use strict;
use warnings;

use DBI;

my $dbh = DBI->connect( 'dbi:SQLite:dbname=test_data' );
{
   local $/ = ";\n";
   $dbh->do( $_ ) while <DATA>;
}

use Test::More tests => 4;
use Test::DatabaseRow;

my $module = 'Users';
use_ok( $module ) or exit;
$module->set_db( $dbh );
$module->create( name => 'Emilia', age => 23 );

local $Test::DatabaseRow::dbh = $dbh;

row_ok(
   sql   => 'SELECT count(*) AS count FROM users',
   tests => [ count => 3 ],
   label => 'create(  ) powinno wstawi wiersz',
);

row_ok(
   table   => 'users',
   where   => [ name => 'Emilia', age => 23 ],
   results => 1,
   label   => '... z poprawnymi danymi',
);

row_ok(
   table => 'users',
   where => [ id => 3 ],
   tests => [ name => 'Emilia', age => 23 ],
   label => '... i nowym id',
);

__END__
BEGIN TRANSACTION;
DROP TABLE users;
CREATE TABLE users (
id   INTEGER primary key,
name varchar(25),
age  int
);
INSERT INTO "users" VALUES(1, 'Renata', 27);
INSERT INTO "users" VALUES(2, 'Benek', 29);
COMMIT;
