#!perl

use strict;
use warnings;

use lib 'lib';

use Test::More tests => 5;
use Test::Exception;

my $module = 'SongPlayer';
use_ok( $module ) or exit;

my $song = $module->new( song => '77s_OneMoreTime.ogg', player => 'mpg321' );

$song->song( 'pass.pl' );
is( $song->song(  ), 'pass.pl', 'song(  ) powinno zaktualizowa skadow song, jeli ustawiona' );

$song->player( $^X );
is( $song->player(  ), $^X, 'player(  ) powinno zaktualizowa skadow member, jeli ustawiona' );

lives_ok { $song->play(  ) } 'play(  ) powinno uruchomi program';

$song->song( 'fail.pl' );
dies_ok { $song->play(  ) } 'play(  ) powinno skrzecze jeli uruchomienie programu si nie uda';

