#!perl

use strict;
use warnings;

use Test::More tests => 23;
use Test::MockObject;

use lib 'lib';

$INC{'Net/SMTP.pm'} = 1;
my $module  = 'MailTemplate';
my $message = do { local $/; <DATA> };

use_ok( $module ) or exit;

can_ok( $module, 'new' );
my $mt = $module->new(
   server => 'smtp.example.com',
   sender => 'A. U. Tor',
   message=> $message,
   sender_address => 'author@example.com',
   recipients => { Robcio => 'bob@example.com' },
);
isa_ok( $mt, $module );

can_ok( $mt, 'server' );
is( $mt->server(  ), 'smtp.example.com', 'server(  ) powinno zwrci serwer podany w konstruktorze' );

can_ok( $mt, 'add_recipient' );
$mt->add_recipient( Alicja => 'alice@example.com' );

can_ok( $mt, 'recipients' );
is_deeply( $mt->recipients(  ),
   { Alicja => 'alice@example.com', Robcio => 'bob@example.com' },
   'recipients(  ) powinno zwrci wszystkich adresatw' );

can_ok( $mt, 'deliver' );

my $smtp = Test::MockObject->new(  );
$smtp->fake_module( 'Net::SMTP', new => sub { $smtp } );
$smtp->set_true( qw( mail to data -quit ) );
$mt->deliver(  );

my %recipients =
(
   Alicja => 'alice@example.com',
   Robcio => 'bob@example.com', 
);

while (my ($name, $address) = each %recipients)
{
   my ($method, $args) = $smtp->next_call(  );
   is( $method,'mail',  'deliver(  ) powinno otworzy list' );
   is( $args->[1], 'author@example.com','... ustawienie adresu From:' );

   ($method, $args) = $smtp->next_call(  );
   is( $method,'to','... potem adresu To:'  );
   is( $args->[1], $address,'... adresata');

   ($method, $args) = $smtp->next_call(  );
   is( $method,  'data', '... wysyanie wiadomoci' );
   like( $args->[1], qr/Witaj $name/,   '... przywitanie'  );
   like( $args->[1], qr/Pozdrawiam,.A. U. Tor/s, '... podpis nadawcy' );
}

__DATA__
To: {address}
From: {sender_address}
Subject: Wiadomo testowa

Witaj {name}!

Tak naprawd nie dostaniesz tej wiadomoci!

Pozdrawiam,
{sender}
