#!perl

use strict;
use warnings;

use lib 'lib';

use Test::More tests => 11;
use Test::MockModule;

my $module = 'LinkFinder';
use_ok( $module ) or exit;
my $html   = do { local $/; <DATA> };

my $vanity = $module->new( $html );
isa_ok( $vanity, $module );
is( $vanity->html(  ), $html, 'new(  ) powinno pozwoli na wczytanie HTML z napisu' );

{
   my $uri;
   my $lwp = Test::MockModule->new( 'LWP::Simple' );
   $lwp->mock( get => sub ($) { $uri = shift; $html } );

   $vanity = $module->new( 'http://www.example.com/somepage.html' );
   is( $vanity->html(  ), $html, '... or from URI if passed' );
   is( $uri, 'http://www.example.com/somepage.html', '... URI przekazane do konstruktora' );
}
 
my @results = $vanity->find_links( 'http' );
is( @results, 3, 'find_links(  ) powinno odnale wszystkie pasujce odnoniki' );
is( $results[0], 'jeden autor', '... w kolejnoci'  );
is( $results[1], 'drugi autor', '... wystpowania' );
is( $results[2], 'projekt',  '... w dokumencie'   );

$vanity->reset(  );
@results= $vanity->find_links( 'perl' );
is( @results, 1,  'reset(  ) powinno wyczyci parser');
is( $results[0], 'projekt', '... pozwalajc na dalsze wyszukiwanie odnonikw' );

__DATA__
<html>
<head><title>some page</title>
<body>
<p><a href="http://wgz.org/chromatic/">jeden autor</a></p>
<p><a href="http://langworth.com/">drugi autor</a></p>
<p><a href="http://qa.perl.org/">projekt</a></p>
</body>
