package Queue::Test;

use base 'Test::Class';

use Queue;
use Test::More;

sub setup_queues : Test( setup => 2 )
{
   my ($self) = @_;

   $self->{empty}   = Queue->new();
   $self->{twoitems} = Queue->new(qw( czoem bonjour ));

   isa_ok( $self->{$_}, 'Queue' ) for qw( empty twoitems );
}

sub size : Test(2)
{
   my ($self) = @_;
   is( $self->{empty}->size(),   0, 'pusta kolejka'          );
   is( $self->{twoitems}->size(), 2, 'kolejka zawierajca jakie elementy' );
}

sub enqueue : Test(1)
{
   my ($self) = @_;
   $self->{twoitems}->enqueue($_) for qw( ciao jo );
   is( $self->{twoitems}->size(), 4, 'kolejka jest teraz dusza' );
}

sub dequeue : Test(3)
{
   my ($self) = @_;

   is( $self->{empty}->dequeue(),   undef,    'pusta kolejka' );

   is( $self->{twoitems}->dequeue(), 'czoem',   'first item'  );
   is( $self->{twoitems}->dequeue(), 'bonjour', 'second item' );
}

1;
