#!perl

use strict;
use warnings;

use DBI;

my $dbh = DBI->connect( 'dbi:SQLite:dbname=test_data' );
{
   local $/ = ";\n";
   $dbh->do( $_ ) while <DATA>;
}

use Test::More tests => 10;

my $module = 'Users';
use_ok( $module ) or exit;

can_ok( $module, 'set_db' );
$module->set_db( $dbh );

can_ok( $module, 'fetch'  );
my $user = $module->fetch( id => 1 );
isa_ok( $user, 'User' );
is( $user->name(  ), 'Renata', 'fetch(  ) powinno pobra uytkownika o danym id' );

$user= $module->fetch( name => 'Benek' );
is( $user->id(  ), 2, '... lub o danym imieniu' );

can_ok( $module, 'create' );
$user= $module->create( name => 'Emilia', age => 23 );
isa_ok( $user, 'User' );
is( $user->name(  ), 'Emilia', 'create(  ) powinno utworzy i zwrci nowy obiekt User');
is( $user->id(  ), 3, '... z poprawnym id' );

__END__
BEGIN TRANSACTION;
DROP TABLE users;
CREATE TABLE users (
id   int,
name varchar(25),
age  int
);
INSERT INTO "users" VALUES(1, 'Renata', 27);
INSERT INTO "users" VALUES(2, 'Benek', 29);
COMMIT;
