#!perl

use strict;
use warnings;

use IO::Scalar;

use Test::More tests => 15;
use DBD::Mock;
use Test::Exception;

my $module  = 'InsertWrapper';
use_ok( $module ) or exit;

my $log_message = '';
my $fh  = IO::Scalar->new( \$log_message );
my $drh = DBI->install_driver( 'Mock' );

can_ok( $module, 'new' );

$drh->{mock_connect_fail} = 1;

my %args = ( dsn => 'dbi:Mock:', logfh => $fh, user => '', password => '' );
throws_ok { $module->new( %args ) } qr/Could not connect/, 'new(  ) powinno si nie uda, gdy nie udaje si poczy z baz danych';

$drh->{mock_connect_fail} = 0;
my $wrap;
lives_ok { $wrap = $module->new( %args ) } '... i zakoczy sukcesem gdy poczenie dziaa';
isa_ok( $wrap, $module );

like( $log_message, qr/CONNECT/,'... logowanie wstawie do bazy danych' );
like( $log_message, qr/\tdsn => $args{dsn}/, '... z dsn'   );
$log_message = '';

can_ok( $module, 'dbh' );
isa_ok( $wrap->dbh(  ), 'DBI::db' );

can_ok( $module, 'insert' );
$wrap->dbh(  )->{mock_can_connect} = 0;

throws_ok { $wrap->insert( 'users', name => 'Janusz', age => 44 ) } qr/prepare failed/, 'insert(  ) powinno zgosi wyjtek gdy nie udaje si prepare';

$wrap->dbh(  )->{mock_can_connect} = 1;
lives_ok { $wrap->insert( 'users', name => 'Janusz', age => 44 ) } '... a i dalej, gdy si to uda';

like( $log_message, qr/INSERT/,  '... logowanie wstawiania do bazy danych' );
like( $log_message, qr/\tname => Janusz/, '... wraz z wstawianymi danymi' );
like( $log_message, qr/\tage => 44/, '... dla kadej kolumny');
