#!perl

use strict;
use warnings;

use lib 'lib';

use Test::More tests => 3;
use Test::Output;
use Test::Output::Tie;

my $module = 'Logger';
use_ok( $module ) or exit;

stderr_is( sub { Logger::write_message( 'Na STDERR!' ) }, 'Na STDERR!', 'write_message(  ) powinno domylnie pisa na STDERR' );

{
   local *Logger::OUTPUT_FH;

   my $out= tie *Logger::OUTPUT_FH, 'Test::Output::Tie';
   $Logger::OUTPUT_FH = *Logger::OUTPUT_FH;

   Logger::write_message( 'Do $out!' );
   is( $out->read(  ), 'Do $out!', '... lub do $OUTPUT_FH, jeli ustawione' );
}
