/* Copyright (C) 1999 Lucent Technologies */
/* rdo: 'Pery programowania' Jona Bentleya */

/* rotate.c -- mierzy prdko algorytmw rotujcych wektor
	Wiersze wejciowe:
		algnum numtests n rotdist
		algnum:
		  1: algorytm odwracajcy 
		  2: algorytm onglujcy 
		  22: algorytm onglujcy z funkcj mod zamiast if 
		  3: algorytm nwd 
		  4: przesu (nie rotuj): bazowy algorytm dla pomiarw 
	Aby testowa algorytmy, przekompiluj i zmie main, aby wywoa testrot
 */

#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#define MAXN 10000000

int x[MAXN];
int rotdist, n;

/* Alg 1: Rotacja przez odwrcenie */

void reverse(int i, int j)
{	int t;
	while (i < j) {
		t = x[i]; x[i] = x[j]; x[j] = t;
		i++;
		j--;
	}
}

void revrot(int rotdist, int n)
{	reverse(0, rotdist-1);
	reverse(rotdist, n-1);
	reverse(0, n-1);
}

/* Alg 2: Rotacja przez onglowanie */

int gcd(int i, int j)
{	int t;
	while (i != 0) {
		if (j >= i)
			j -= i;
		else {
			t = i; i = j; j = t;
		}
	}
	return j;
}

void jugglerot(int rotdist, int n)
{	int cycles, i, j, k, t;
	cycles = gcd(rotdist, n);
	for (i = 0; i < cycles; i++) {
		/* przesu i-te wartoci blokw */
		t = x[i];
		j = i;
		for (;;) {
			k = j + rotdist;
			if (k >= n)
				k -= n;
			if (k == i)
				break;
			x[j] = x[k];
			j = k;
		}
		x[j] = t;
	}
}

void jugglerot2(int rotdist, int n)
{	int cycles, i, j, k, t;
	cycles = gcd(rotdist, n);
	for (i = 0; i < cycles; i++) {
		/* przesu i-te wartoci blokw */
		t = x[i];
		j = i;
		for (;;) {
          /* Zastp ponisz funkcj mod 
			k = j + rotdist;
			if (k >= n)
				k -= n;
           */
            k = (j + rotdist) % n;
			if (k == i)
				break;
			x[j] = x[k];
			j = k;
		}
		x[j] = t;
	}
}

/* Alg 3: Rotacja rekursywna (z uyciem struktury nwd) */

void swap(int i, int j, int k) /* swap x[i..i+k-1] with x[j..j+k-1] */
{	int t;
	while (k-- > 0) {
		t = x[i]; x[i] = x[j]; x[j] = t;
		i++;
		j++;
	}

}

void gcdrot(int rotdist, int n)
{	int i, j, p;
	if (rotdist == 0 || rotdist == n)
		return;
	i = p = rotdist;
	j = n - p;
	while (i != j) {
		/* niezmiennik:
			x[0  ..p-i  ] znajduje si na pozycji kocowej 
			x[p-i..p-1  ] = a (do zamiany z b)
			x[p  ..p+j-1] = b (do zamiany z a)
			x[p+j..n-1  ] na pozycji kocowej
		*/
		if (i > j) {
			swap(p-i, p, j);
			i -= j;
		} else {
			swap(p-i, p+j-i, i);
			j -= i;
		}
	}
	swap(p-i, p, i);
}

int isogcd(int i, int j)
{	if (i == 0) return j;
	if (j == 0) return i;
	while (i != j) {
		if (i > j)
			i -= j;
		else 
			j -= i;
	}
	return i;
}

void testgcd()
{
	int i,j;
	while (scanf("%d %d", &i, &j) != EOF)
		printf("%d\n", isogcd(i,j) );
}

/* Testuj wszystkie algorytmy */

void slide(int rotdist, int n) /* Punkt odniesienia: rotdist przesunicie w lewo (utrata 0..rotdist-1) */
{	int i;

	for (i = rotdist; i < n; i++)
		x[i-rotdist] = x[i];
}

void initx()
{
	int i;
	for (i = 0; i < n; i++)
		x[i] = i;
}

void printx()
{	int i;
	for (i = 0; i < n; i++)
		printf(" %d", x[i]);
	printf("\n");
}

void roterror()
{
	fprintf(stderr, " bd rotacji %d %d\n", n, rotdist);
	printx();
	exit (1);
}

void checkrot()
{	int i;
	for (i = 0; i < n-rotdist; i++)
		if (x[i] != i+rotdist)
			roterror();
	for (i = 0; i < rotdist; i++)
		if (x[n-rotdist+i] != i)
			roterror();
}

void testrot()
{	for (n = 1; n <= 20; n++) {
		printf(" testowanie n=%d\n", n);
		for (rotdist = 0; rotdist <= n; rotdist++) {
			/* printf("  testowanie rotdist=%d\n", rotdist); */
			initx(); revrot(rotdist, n);     checkrot();
			initx(); jugglerot(rotdist, n);  checkrot();
			initx(); jugglerot2(rotdist, n); checkrot();
			initx(); gcdrot(rotdist, n);     checkrot();
		}
	}
}

/* Pomiar czasu */

void timedriver()
{	int i, algnum, numtests, start, clicks;
	while (scanf("%d %d %d %d", &algnum, &numtests, &n, &rotdist) != EOF) {
		initx();
		start = clock();
		for (i = 0; i < numtests; i++) {
			if (algnum == 1)
				revrot(rotdist, n);
			else if (algnum == 2)
				jugglerot(rotdist, n);
			else if (algnum == 22)
				jugglerot2(rotdist, n);
			else if (algnum == 3)
				gcdrot(rotdist, n);
			else if (algnum == 4)
				slide(rotdist, n);
		}
		clicks = clock() - start;
		printf("%d\t%d\t%d\t%d\t%d\t%g\n",
			algnum, numtests, n, rotdist, clicks,
			1e9*clicks/((float) CLOCKS_PER_SEC*n*numtests));
	}
}

/* Main */

int main()
{	/* testrot(); */
	timedriver();
	return 0;
}
