<?php
/**
 * Przechowuje informacje o etykiecie studia (albumu)
 * i artycie, ktry go nagra
 */
class Label {
    public $name    = null;
    public $artists = array();
    
    public function __construct($name) {
        $this->name = $name;
    }
    public function signArtist(Artist $artist) {
        // pobieramy kolejny, wyszy identyfikator
        $artist->setId(count($this->artists)+1);
        $this->artists[] = $artist;
    }
}

/**
 * Przechowuje informacje o artycie 
 * i nagranych przez niego albumach
 */
class Artist {
    public $id      = null;
    public $name    = null;
    public $records = array();
    
    public function __construct($name) {
        $this->name = $name;
    }
    public function setId($id) {
        $this->id = $id;
    }    
    public function recordAlbum(Record $album) {
        $this->records[] = $album;
    }
}

/**
 * Przechowuje informacje o albumie.
 */
class Record {
    public $id       = null;
    public $name     = null;
    public $released = null;
    
    public function __construct($id, $name, $released) {
        $this->id       = $id;
        $this->name     = $name;
        $this->released = $released;
    }
}

?>