<?php
require_once 'XML/RPC.php';

$client = new XML_RPC_Client('/xmlrpc.php', 'pear.php.net');

$params = array(new XML_RPC_Value('XML', 'string'));
$message = new XML_RPC_Message('package.search', $params);

$response = $client->send($message);

if ($response->faultCode()) {
	echo "Nie mog skorzysta z usugi XML-RPC.\n";
	echo $response->faultString();
	exit();
}

$value = $response->value();
$packages = XML_RPC_decode($value);

foreach ($packages as $packageName => $packageInfo) {
	echo "$packageName: ";
	echo "{$packageInfo['summary']}\n";
}
?>