<?php
/**
 * Korzystamy z klasy Services_AmazonECS4 
 */
require_once 'Services/AmazonECS4.php';

// Nasz identyfikator subskrypcji 
$subscriptionId = '0DDMH995CMFWSXK3A6G2';

// Nasz identyfikator partnera Amazon 
$accociateId = 'schstnet-20';

// tworzymy nowego klinta przesyaj
// identyfikatory subskrypcji i partnera Amazon
$amazon  = new Services_AmazonECS4($subscriptionId, $accociateId);
$amazon->setLocale('US');

$options = array();
$options['Keywords'] = 'PEAR';
$result = $amazon->ItemSearch('Books', $options);

if (PEAR::isError($result)) {
	print "An error occured\n";
	print $result->getMessage() . "\n";
	exit();
}

foreach ($result['Item'] as $book) {
    $title  = $book['ItemAttributes']['Title'];
    $author = $book['ItemAttributes']['Author'];
    if (is_array($author)) {
    	$author = implode(', ', $author);
    }
    printf("%s by %s\n", $title, $author);
}
?>