<?php
require_once 'XML/XUL.php';

// tworzymy nowy dokument
$doc = XML_XUL::createDocument();

// czymy go z arkuszem stylw dostarczonym przez uytkownika
$doc->addStylesheet('chrome://global/skin/');

// tworzymy nowe okno
$win = $doc->createElement('window',array(
                                      'title'=> 'Simple XUL'
                                     )
                           );
// dodajemy je do dokumentu
$doc->addRoot($win);

// Tworzymy karty z zakadkami i dodajemy je do okna
$tabbox = &$doc->createElement('Tabbox', array('height' => 500));
$win->appendChild($tabbox);

// Tworzymy nowe drzewo
$tree = &$doc->createElement('Tree',
                                array(
                                  'flex' => 1,
                                  'height' => 200
                                )
                            );

// Okrelamy etykiety kolumn
$tree->setColumns(3,
                     array(
                       'id'      => 'id',
                       'label'   => 'Id',
                       'flex'    => 1,
                       'primary' => 'true'
                     ),
                     array(
                       'id'      => 'name',
                       'label'   => 'Name',
                       'flex'    => 1
                     ),
                     array(
                       'id'      => 'email',
                       'label'   => 'E-Mail',
                       'flex'    => 1
                     )
                 );

// dodajemy nowy element do drzewa
$sun = $tree->addItem(array('SUN', 'Sun Records', 'info@sun-records.com'));

// dodajemy do utworzonego elementu dwa nowe elementy niszego rzdu 
$sun->addItem(array('elvis', 'Elvis Presley', 'elvis@graceland.com'));
$sun->addItem(array('carl', 'Carl Perkins', 'carl@sun-records.com'));

// dodajemy nowy element do drzewa
$tree->addItem(array('SONY', 'Sony Records', 'info@sony.com'));

// dodajemy now zakadk do etykiety, zawartoci zakadki bdzie drzewo  
$tabbox->addTab('Labels', $tree, array(), array('height' => 200));

// dodajemy kolejn zakadk, jednak bez zawartoci  
$tab2 = $tabbox->addTab('Misc');

// do drugiej zakadki dodajemy przykadow zawarto tekstow 
$tab2->addDescription('Tu mozna doda opis.');

header( 'Content-type: application/vnd.mozilla.xul+xml' );
$doc->send();
?>