<?php
error_reporting(E_ALL);

require_once 'Calendar/Month/Weekdays.php';
require_once 'Calendar/Util/Uri.php';
require_once 'Calendar/Day.php';
require_once 'Date.php';
require_once 'Date/Holidays.php';
require_once 'Calendar_Decorator_Holiday.php';

setlocale(LC_ALL, $locale= 'en_US');

// pobieramy informacje o dacie z dania lub uywamy biecej daty
$y = sprintf('%04d', isset($_GET['year']) ? $_GET['year'] :
date('Y'));
$m = sprintf('%02d', isset($_GET['month']) ? $_GET['month'] :
date('m'));

// pobieramy wita dla wywietlanego miesica
$startDate = new Date($y .'-'. $m . '-01 00:00:00');
$endDate = new Date($y .'-'. $m . '-01 00:00:00');
$endDate->setDay($endDate->getDaysInMonth());
$driver = Date_Holidays::factory('Christian', $y, $locale);
if (Date_Holidays::isError($driver))
{
   die('Nie udao si utworzy sterownika: ' . $driver->getMessage());
}
$holidays = $driver->getHolidaysForDatespan($startDate, $endDate);
if (Date_Holidays::isError($holidays))
{
   die('Bd podczas pobierania wit: ' . $holidays->getMessage());
}

// tworzymy tablic wybranych dni zawierajc dekorowane obiekty 
// dla metody build()
$selection = array();
foreach ($holidays as $holiday)
{
   $date = $holiday->getDate();
   $day = new Calendar_Day($date->getYear(), $date->getMonth(),
                                               $date->getDay());
   $selection[] = new Calendar_Decorator_Holiday($day, $holiday);
}

$month = new Calendar_Month_Weekdays($y, $m, $firstDay = 1);
$month->build($selection);

// Lokalizowany tekst dla nagwka kalendarza
$header = strftime('%B %Y', $month->thisMonth('timestamp'));

// Klasa Calendar_URI_Util generujca cza nawigacyjne
$uriUtil = new Calendar_Util_Uri('year', 'month');
$nextM = $uriUtil->next($month, 'month');
$prevM = $uriUtil->prev($month, 'month');

echo <<<EOQ
<style type="text/css">
   div.empty {background-color: #bfbfbf;}
   div.holiday {background-color: #b8ffa4;}
</style>

<table width="250" cellpadding="0" cellspacing="0">
   <!-- calendar headline -->
   <tr>
      <td align="left"><a href="{$_SERVER['PHP_SELF']}?
                                 $prevM">&lt;</a></td>
      <td colspan="5" align="center">$header</td>
      <td align="right"><a href="{$_SERVER['PHP_SELF']}?
                                  $nextM">&gt;</td>
   </tr>
   <tr>
      <td align="center">Pon</td>
      <td align="center">Wto</td>
      <td align="center">ro</td>
      <td align="center">Czw</td>
      <td align="center">Pi</td>
      <td align="center">Sob</td>
      <td align="center">Nie</td>
   </tr>
   <!-- dane kalendarza -->
   <tr>
EOQ;

// przegldamy zbudowane dni tygodnia i wywietlamy je
while ($day = & $month->fetch())
{
   if ($day->isFirst())
   {
      echo '<tr>';
   }

   if ($day->isEmpty())
   {
      echo '<td><div class="empty">&nbsp;</div></td>';
   }
      else
   {
      if ($day->isSelected())
      {
         echo '<td align="center"><div class="holiday" '
             . 'title="' . $day->getHoliday()->getTitle() . '">'.
                                                   $day->thisDay()
            . '</div></td>';
      }
         else
      {
         echo '<td align="center"><div>'.$day->thisDay().'</div></td>';
      }
   }

   if ($day->isLast())
   {
      echo "</tr>\n";
   }
}
echo '</table>';

?>