 #include <stdio.h>
 #include <string.h>
 #include "dbg.h"

 int normal_copy(char *from, char *to, int count)
 {
     int i = 0;

     for (i = 0; i < count; i++) {
         to[i] = from[i];
 }

     return i;
 }

 int duffs_device(char *from, char *to, int count)
 {
     {
         int n = (count + 7) / 8;

         switch (count % 8) {
             case 0:
                 do {
                     *to++ = *from++;
                     case 7:
                     *to++ = *from++;
                     case 6:
                     *to++ = *from++;
                     case 5:
                     *to++ = *from++;
                     case 4:
                     *to++ = *from++;
                     case 3:
                     *to++ = *from++;
                     case 2:
                     *to++ = *from++;
                     case 1:
                     *to++ = *from++;
                 } while (--n > 0);
         }
     }

     return count;
 }

 int zeds_device(char *from, char *to, int count)
 {
     {
         int n = (count + 7) / 8;

         switch (count % 8) {
             case 0:
 again: *to++ = *from++;

             case 7:
             *to++ = *from++;
             case 6:
             *to++ = *from++;
             case 5:
             *to++ = *from++;
             case 4:
             *to++ = *from++;
             case 3:
             *to++ = *from++;
             case 2:
             *to++ = *from++;
             case 1:
             *to++ = *from++;
             if (--n > 0)
                 goto again;
         }
     }

     return count;
 }

 int valid_copy(char *data, int count, char expects)
 {
     int i = 0;
     for (i = 0; i < count; i++) {
         if (data[i] != expects) {
             log_err("[%d] %c != %c", i, data[i], expects);
             return 0;
         }
     }

     return 1;
 }

 int main(int argc, char *argv[])
 {
     char from[1000] = { 'a' };
     char to[1000] = { 'c' };
     int rc = 0;

     // Konfiguracja.
     memset(from, 'x', 1000);
     // Zdefiniowanie trybu awarii.
     memset(to, 'y', 1000);
     check(valid_copy(to, 1000, 'y'), "Nie zainicjalizowano prawidłowo.");

     // Użycie zwykłego kopiowania.
     rc = normal_copy(from, to, 1000);
     check(rc == 1000, "Zwykłe kopiowanie nie udało się: %d", rc);
     check(valid_copy(to, 1000, 'x'), "Zwykłe kopiowanie nie udało się.");

     // Zerowanie.
     memset(to, 'y', 1000);

     // Mechanizm Duffa.
     rc = duffs_device(from, to, 1000);
     check(rc == 1000, "Mechanizm Duffa uległ awarii: %d", rc);
     check(valid_copy(to, 1000, 'x'), "Mechanizm Duffa uległ awarii.");

     // Zerowanie.
     memset(to, 'y', 1000);

     // Moja wersja.
     rc = zeds_device(from, to, 1000);
     check(rc == 1000, "Mechanizm Zeda uległ awarii: %d", rc);
     check(valid_copy(to, 1000, 'x'), "Mechanizm Zeda uległ awarii.");

     return 0;
 error:
     return 1;
 }
