 #include "minunit.h"
 #include <dlfcn.h>

 typedef int (*lib_function) (const char *data);
 char *lib_file = "build/libYOUR_LIBRARY.so";
 void *lib = NULL;

 int check_function(const char *func_to_run, const char *data,
     int expected)
 {
     lib_function func = dlsym(lib, func_to_run);
     check(func != NULL,
         "Nie znaleziono funkcji %s w bibliotece %s: %s", func_to_run,
         lib_file, dlerror());

     int rc = func(data);
     check(rc == expected, "Funkcja %s zwróciła %d dla danych: %s",
         func_to_run, rc, data);

     return 1;
 error:
     return 0;
 }

 char *test_dlopen()
 {
     lib = dlopen(lib_file, RTLD_NOW);
     mu_assert(lib != NULL, " Nie udało się otworzyć biblioteki do testów.");

     return NULL;
 }

 char *test_functions()
 {
     mu_assert(check_function("print_a_message", "Witaj", 0),
         "Wykonanie funkcji print_a_message() zakończyło się niepowodzeniem.");
     mu_assert(check_function("uppercase", "Witaj", 0),
         "Wykonanie funkcji uppercase() zakończyło się niepowodzeniem.");
     mu_assert(check_function("lowercase", "Witaj", 0),
         "Wykonanie funkcji lowercase() zakończyło się niepowodzeniem.");

     return NULL;
 }

 char *test_failures()
 {
     mu_assert(check_function("fail_on_purpose", "Witaj", 1),
         "Wykonanie funkcji fail_on_purpose() powinno zakończyć się niepowodzeniem.");

     return NULL;
 }

 char *test_dlclose()
 {
     int rc = dlclose(lib);
     mu_assert(rc == 0, " Nie udało się zamknąć biblioteki.");

     return NULL;
 }

 char *all_tests()
 {
     mu_suite_start();

     mu_run_test(test_dlopen);
     mu_run_test(test_functions);
     mu_run_test(test_failures);
     mu_run_test(test_dlclose);

     return NULL;
 }

 RUN_TESTS(all_tests);
