 #include <stdio.h>
 #include "dbg.h"
 #include <dlfcn.h>

 typedef int (*lib_function) (const char *data);

 int main(int argc, char *argv[])
 {
     int rc = 0;
     check(argc == 4, "UŻYCIE: e29 libex29.so funkcja dane");

     char *lib_file = argv[1];
     char *func_to_run = argv[2];
     char *data = argv[3];

     void *lib = dlopen(lib_file, RTLD_NOW);
     check(lib != NULL, "Nie udało się otworzyć biblioteki %s: %s", lib_file,
         dlerror());

     lib_function func = dlsym(lib, func_to_run);
     check(func != NULL,
         "Nie znaleziono funkcji %s w bibliotece %s: %s", func_to_run,
         lib_file, dlerror());

     rc = func(data);
     check(rc == 0, "Funkcja %s zwróciła %d dla danych: %s", func_to_run,
         rc, data);

     rc = dlclose(lib);
     check(rc == 0, "Nie udało się zamknąć %s", lib_file);

     return 0;

 error:
     return 1;
 }
