 #undef NDEBUG
 #include <assert.h>
 #include <stdio.h>
 #include <stdlib.h>
 #include <string.h>
 #include <lcthw/dbg.h>
 #include <lcthw/ringbuffer.h>

 RingBuffer *RingBuffer_create(int length)
 {
     RingBuffer *buffer = calloc(1, sizeof(RingBuffer));
     buffer->length = length + 1;
     buffer->start = 0;
     buffer->end = 0;
     buffer->buffer = calloc(buffer->length, 1);

     return buffer;
 }

 void RingBuffer_destroy(RingBuffer * bufferP
 {
     if (buffer) {
         free(buffer->buffer);
         free(buffer);
     }
 }

 int RingBuffer_write(RingBuffer * buffer, char *data, int lengthP
 {
     if (RingBuffer_available_data(buffer) == 0) {
         buffer->start = buffer->end = 0;
     }

     check(length <= RingBuffer_available_space(buffer),
         "Brak wystarczającej ilości miejsca: %d żądane, %d dostępne",
         RingBuffer_available_data(buffer), length);

     void *result = memcpy(RingBuffer_ends_at(buffer), data, length);
     check(result != NULL, "Nie udało się zapisać danych w buforze.");

     RingBuffer_commit_write(buffer, length);

     return length;
 error:
     return -1;
 }

 int RingBuffer_read(RingBuffer * buffer, char *target, int amount)
 {
     check_debug(amount <= RingBuffer_available_data(buffer),
         "Brak wystarczającej ilości miejsca w buforze: jest %d, potrzeba %d",
         RingBuffer_available_data(buffer), amount);

     void *result = memcpy(target, RingBuffer_starts_at(buffer), amount);
     check(result != NULL, "Nie udało się zapisać bufora w danych.");

     RingBuffer_commit_read(buffer, amount);

     if (buffer->end == buffer->start) {
         buffer->start = buffer->end = 0;
     }

     return amount;
 error:
     return -1;
 }

 bstring RingBuffer_gets(RingBuffer * buffer, int amount)
 {
     check(amount > 0, "Potrzeba więcej niż 0 dla get, otrzymano: %d ",
         amount);
     check_debug(amount <= RingBuffer_available_data(buffer),
         "Brak wystarczającej ilości w buforze.");

     bstring result = blk2bstr(RingBuffer_starts_at(buffer), amount);
     check(result != NULL, "Nie udało się utworzyć wyniku.");
     check(blength(result) == amount, "Nieprawidłowa wielkość wyniku.");

     RingBuffer_commit_read(buffer, amount);
     assert(RingBuffer_available_data(buffer) >= 0
         && "Błąd podczas odczytu.");

     return result;
 error:
     return NULL;
 }
