 #undef NDEBUG
 #ifndef _minunit_h
 #define _minunit_h

 #include <stdio.h>
 #include <dbg.h>
 #include <stdlib.h>

 #define mu_suite_start() char *message = NULL

 #define mu_assert(test, message) if (!(test)) {\
     log_err(message); return message; }
 #define mu_run_test(test) debug("\n-----%s", " " #test); \
     message = test(); tests_run++; if (message) return message;

 #define RUN_TESTS(name) int main(int argc, char *argv[]) {\
     argc = 1; \
     debug("----- WYKONYWANIE: %s", argv[0]);\
     printf("----\nWYKONYWANIE: %s\n", argv[0]);\
     char *result = name();\
     if (result != 0) {\
         printf("NIEPOWODZENIE: %s\n", result);\
     }\
     else {\
         printf("WSZYSTKIE TESTY ZOSTAŁY ZALICZONE\n");\
     }\
     printf("Liczba wykonanych testów: %d\n", tests_run);\
     exit(result != 0);\
 }

 int tests_run;

 #endif
