 #include "minunit.h"
 #include <lcthw/list_algos.h>
 #include <assert.h>
 #include <string.h>

 char *values[] = { "XXXX", "1234", "abcd", "xjvef", "NDSS" };

 #define NUM_VALUES 5

 List *create_words()
 {
     int i = 0;
     List *words = List_create();

     for (i = 0; i < NUM_VALUES; i++) {
         List_push(words, values[i]);
     }

     return words;
 }

 int is_sorted(List * words)
 {
     LIST_FOREACH(words, first, next, cur) {
         if (cur->next && strcmp(cur->value, cur->next->value) > 0) {
             debug("%s %s", (char *)cur->value,
                 (char *)cur->next->value);
             return 0;
         }
     }

     return 1;
 }

 char *test_bubble_sort()
 {
     List *words = create_words();

     // Poniższy kod powinien działać na liście wymagającej posortowania.
     int rc = List_bubble_sort(words, (List_compare) strcmp);
     mu_assert(rc == 0, "Sortowanie bąbelkowe zakończyło się niepowodzeniem.");
     mu_assert(is_sorted(words),
         "Słowa nie są posortowane po przeprowadzeniu sortowania bąbelkowego.");

     // Poniższy kod powinien działać na już posortowanej liście.
     rc = List_bubble_sort(words, (List_compare) strcmp);
     mu_assert(rc == 0, "Sortowanie bąbelkowe już posortowanej listy zakończyło się niepowodzeniem.");
     mu_assert(is_sorted(words),
         "Słowa powinny być sortowane, jeśli przeprowadzono sortowanie bąbelkowe.");

     List_destroy(words);

     // Poniższy kod powinien działać na pustej liście.
     words = List_create(words);
     rc = List_bubble_sort(words, (List_compare) strcmp);
     mu_assert(rc == 0, "Sortowanie bąbelkowe pustej listy zakończyło się niepowodzeniem.");
     mu_assert(is_sorted(words), "Słowa powinny być sortowane, jeśli lista jest pusta.");

     List_destroy(words);

     return NULL;
 }

 char *test_merge_sort()
 {
     List *words = create_words();

     // Poniższy kod powinien działać na liście wymagającej posortowania.
     List *res = List_merge_sort(words, (List_compare) strcmp);
     mu_assert(is_sorted(res), "Słowa nie są posortowane po przeprowadzeniu sortowania przez scalanie.");

     List *res2 = List_merge_sort(res, (List_compare) strcmp);
     mu_assert(is_sorted(res),
         "Lista nadal powinna być posortowana po przeprowadzeniu sortowania przez scalanie.");
     List_destroy(res2);
     List_destroy(res);

     List_destroy(words);
     return NULL;
 }

 char *all_tests()
 {
     mu_suite_start();

     mu_run_test(test_bubble_sort);
     mu_run_test(test_merge_sort);

     return NULL;
 }

 RUN_TESTS(all_tests);
