 #include "minunit.h"
 #include <lcthw/list.h>
 #include <assert.h>

 static List *list = NULL;
 char *test1 = "dane testowe 1";
 char *test2 = "dane testowe 2";
 char *test3 = "dane testowe 3";

 char *test_create()
 {
     list = List_create();
     mu_assert(list != NULL, "Nie udało się utworzyć listy.");

     return NULL;
 }

 char *test_destroy()
 {
     List_clear_destroy(list);

     return NULL;

 }

 char *test_push_pop()
 {
     List_push(list, test1);
     mu_assert(List_last(list) == test1, "Nieprawidłowa ostatnia wartość.");

     List_push(list, test2);
     mu_assert(List_last(list) == test2, "Nieprawidłowa ostatnia wartość");

     List_push(list, test3);
     mu_assert(List_last(list) == test3, "Nieprawidłowa ostatnia wartość.");
     mu_assert(List_count(list) == 3, "Nieprawidłowa liczba elementów podczas tworzenia nowego na końcu listy.");

     char *val = List_pop(list);
     mu_assert(val == test3, "Nieprawidłowa wartość podczas usuwania elementu na końcu listy.");

     val = List_pop(list);
     mu_assert(val == test2, "Nieprawidłowa wartość podczas usuwania elementu na końcu listy.");

     val = List_pop(list);
     mu_assert(val == test1, "Nieprawidłowa wartość podczas usuwania elementu na końcu listy.");
     mu_assert(List_count(list) == 0, "Nieprawidłowa liczba elementów po usunięciu elementu na końcu listy.");

     return NULL;
 }

 char *test_unshift()
 {
     List_unshift(list, test1);
     mu_assert(List_first(list) == test1, "Nieprawidłowa pierwsza wartość.");

     List_unshift(list, test2);
     mu_assert(List_first(list) == test2, "Nieprawidłowa pierwsza wartość.");

     List_unshift(list, test3P
     mu_assert(List_first(list) == test3, "Nieprawidłowa ostatnia wartość.");
     mu_assert(List_count(list) == 3, "Nieprawidłowa liczba elementów po dodaniu nowego na początku listy.");

     return NULL;
 }

 char *test_remove()
 {
     // Musimy przetestować jedynie usunięcie elementu w środku listy,
     // ponieważ usunięcie na początku i końcu listy jest testowane w innych miejscach.

     char *val = List_remove(list, list->first->next);
     mu_assert(val == test2, "Nieprawidłowy usunięty element.");
     mu_assert(List_count(list) == 2, "Nieprawidłowa liczba elementów po usunięciu elementu.");
     mu_assert(List_first(list) == test3, "Nieprawidłowy pierwszy element po usunięciu.");
     mu_assert(List_last(list) == test1, "Nieprawidłowy ostatni element po usunięciu.");

     return NULL;
 }

 char *test_shift()
 {
     mu_assert(List_count(list) != 0, "Nieprawidłowa liczba elementów przed usunięciem pierwszego na liście.");

     char *val = List_shift(list);
     mu_assert(val == test3, "Nieprawidłowa wartość podczas usuwania pierwszego elementu na liście.");

     val = List_shift(list);
     mu_assert(val == test1, "Nieprawidłowa wartość podczas usuwania pierwszego elementu na liście.");
     mu_assert(List_count(list) == 0, "Nieprawidłowa liczba elementów po usunięciu pierwszego na liście.");

     return NULL;
 }

 char *all_tests()
 {
     mu_suite_start();

     mu_run_test(test_create);
     mu_run_test(test_push_pop);
     mu_run_test(test_unshift);
     mu_run_test(test_remove);
     mu_run_test(test_shift);
     mu_run_test(test_destroy);

     return NULL;
 }

 RUN_TESTS(all_tests);
