 #include <stdio.h>
 #include <stdlib.h>
 #include <errno.h>
 #include <string.h>

 /** Nasz stary przyjaciel, czyli funkcja die() z rozdziału 17. */
 void die(const char *message)
 {
     if (errno) {
         perror(message);
     } else {
         printf("BŁĄD: %s\n", message);
     }

     exit(1);
 }

 // Polecenie typedef tworzy nieprawdziwy typ.
 // W omawianym programie to typ dla wskaźnika funkcji.
 typedef int (*compare_cb) (int a, int b);

 /**
 * Klasyczna funkcja sortowania bąbelkowego, która
 * używa compare_cb do przeprowadzenia sortowania.
 */
 int *bubble_sort(int *numbers, int count, compare_cb cmp)
 {
     int temp = 0;
     int i = 0;
     int j = 0;
     int *target = malloc(count * sizeof(int));

     if (!target)
         die("Błąd pamięci.");

     memcpy(target, numbers, count * sizeof(int));

     for (i = 0; i < count; i++) {
         for (j = 0; j < count - 1; j++) {
             if (cmp(target[j], target[j + 1]) > 0) {
                 temp = target[j + 1];
                 target[j + 1] = target[j];
                 target[j] = temp;
             }
         }
     }

     return target;
 }

 int sorted_order(int a, int b)
 {
     return a - b;
 }

 int reverse_order(int a, int b)
 {
     return b - a;
 }

 int strange_order(int a, int b)
 {
     if (a == 0 || b == 0) {
         return 0;
     } else {
         return a % b;
     }
 }

 /**
 * Funkcja używana do sprawdzenia, czy elementy są sortowane prawidłowo.
 * Odbywa się to przez posortowanie i wyświetlenie elementów.
 */
 void test_sorting(int *numbers, int count, compare_cb cmp)
 {
     int i = 0;
     int *sorted = bubble_sort(numbers, count, cmp);

     if (!sorted)
         die("Nie udało się przeprowadzić sortowania.");

     for (i = 0; i < count; i++) {
         printf("%d ", sorted[i]);
     }
     printf("\n");

     free(sorted);
 }

 int main(int argc, char *argv[])
 {
     if (argc < 2) die("UŻYCIE: ex18 4 3 1 5 6");

     int count = argc - 1;
     int i = 0;
     char **inputs = argv + 1;

     int *numbers = malloc(count * sizeof(int));
     if (!numbers) die("Błąd pamięci.");

     for (i = 0; i < count; i++) {
         numbers[i] = atoi(inputs[i]);
     }

     test_sorting(numbers, count, sorted_order);
     test_sorting(numbers, count, reverse_order);
     test_sorting(numbers, count, strange_order);

     free(numbers);

     return 0;
 }
