
//
// To jest przykadowy kod z podrozdziau 23.7 Wyszukiwanie przy uyciu wyrae regularnych ksiki
// "Programowanie. Teoria i praktyka z wykorzystaniem C++" Bjarne'a Stroustrupa.
//

#include <boost/regex.hpp>
#include <iostream>
#include <stdexcept>
#include <string>
#include <fstream>

using namespace std;

//------------------------------------------------------------------------------

int main()
try
{
    ifstream in("file.txt");    // plik wejciowy
    if (!in) cerr << "no file\n";

    boost::regex pat ("\\w{2}\\s*\\d{5}(-\\d{4})?");    // wzorzec kodu pocztowego
    cout << "Wzorzec: " << pat << '\n';

    int lineno = 0;
    string line;    // bufor wejciowy
    while (getline(in,line)) {
        ++lineno;
        boost::smatch matches;    // Tu s zapisywane pasujce acuchy.
        if (boost::regex_search(line, matches, pat)) {
            cout << lineno << ": " << matches[0] << '\n';
            if (1<matches.size() && matches[1].matched)
                cout  << "\t: " << matches[1] << '\n';    // poddopasowanie
        }
    }
}
catch (std::exception& e) {
    cerr << "Bd: " << e.what() << '\n'; 
    return 1;
}
catch (...) {
    cerr << "Nieznany wyjtek!\n"; 
    return 2;
};

//------------------------------------------------------------------------------
