
//
// To jest przykadowy kod z podrozdziau 21.3 Oglny algorytm wyszukiwania  find_if() ksiki
// "Programowanie. Teoria i praktyka z wykorzystaniem C++" Bjarne'a Stroustrupa.
//

#include <list>
#include <vector>

using namespace std;

//------------------------------------------------------------------------------

template<class In, class Pred>
In find_if(In first, In last, Pred pred)
{
    while (first!=last && !pred(*first)) ++first;
    return first;
}

//------------------------------------------------------------------------------

bool odd(int x) { return x%2; }    // % to operator modulo.

void f(vector<int>& v)
{
    vector<int>::iterator p = find_if(v.begin(), v.end(), odd);
    if (p!=v.end()) { /* znaleziono nieparzyst liczb */ }
    // ...
}

//------------------------------------------------------------------------------

bool larger_than_42(int x) { return x>42; }

void f(list<double>& v)
{
    list<double>::iterator p = find_if(v.begin(), v.end(), larger_than_42);
    if (p!=v.end()) { /* znaleziono warto wiksz od 42 */ }
    // ...
}

//------------------------------------------------------------------------------

int v;        // Warto, z ktr larger_than_v() porwnuje swj argument.
bool larger_than_v(int x) { return x>v; }

void f(list<double>& v, int x)
{
    ::v = 31; // Ustawia v_val na 31 dla nastpnego wywoania larger_than_v.
    list<double>::iterator p = find_if(v.begin(), v.end(), larger_than_v);
    if (p!=v.end()) { /* znaleziono warto wiksz od 31 */ }

    ::v = x;  // Ustawia v_val na x dla nastpnego wywoania larger_than_v.
    list<double>::iterator q = find_if(v.begin(), v.end(), larger_than_v);
    if (q!=v.end()) { /* znaleziono warto wiksz od x*/  }

    // ...
}

//------------------------------------------------------------------------------

int main()
{
    // Dziaa dla wektorw liczb typu int.
    {
        int initializer[7] = {1,2,3,4,5,6,7};
        int* first = initializer;
        int* last  = initializer+7;

        vector<int> v(first,last);
        f(v);
    }

    // Dziaa dla list liczb typu double.
    {
        double  initializer[7] = {1.1, 2.2, 3.3, 4.4, 5.5, 6.6, 7.7};
        double* first = initializer;
        double* last  = initializer+7;

        list<double> l(first,last);
        f(l);
        f(l,4);
    }
}

//------------------------------------------------------------------------------
